/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about how a source JSON data file should be analyzed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JsonFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<JsonFormatDescriptor.Builder, JsonFormatDescriptor> {
    private static final SdkField<String> FILE_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileCompression").getter(getter(JsonFormatDescriptor::fileCompressionAsString))
            .setter(setter(Builder::fileCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()).build();

    private static final SdkField<String> CHARSET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Charset")
            .getter(getter(JsonFormatDescriptor::charset)).setter(setter(Builder::charset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD,
            CHARSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileCompression;

    private final String charset;

    private JsonFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
    }

    /**
     * <p>
     * The level of compression of the source CSV file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCompression}
     * will return {@link JsonFileCompression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileCompressionAsString}.
     * </p>
     * 
     * @return The level of compression of the source CSV file.
     * @see JsonFileCompression
     */
    public final JsonFileCompression fileCompression() {
        return JsonFileCompression.fromValue(fileCompression);
    }

    /**
     * <p>
     * The level of compression of the source CSV file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCompression}
     * will return {@link JsonFileCompression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileCompressionAsString}.
     * </p>
     * 
     * @return The level of compression of the source CSV file.
     * @see JsonFileCompression
     */
    public final String fileCompressionAsString() {
        return fileCompression;
    }

    /**
     * <p>
     * The character set in which the source JSON file is written.
     * </p>
     * 
     * @return The character set in which the source JSON file is written.
     */
    public final String charset() {
        return charset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonFormatDescriptor)) {
            return false;
        }
        JsonFormatDescriptor other = (JsonFormatDescriptor) obj;
        return Objects.equals(fileCompressionAsString(), other.fileCompressionAsString())
                && Objects.equals(charset(), other.charset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JsonFormatDescriptor").add("FileCompression", fileCompressionAsString())
                .add("Charset", charset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCompression":
            return Optional.ofNullable(clazz.cast(fileCompressionAsString()));
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileCompression", FILE_COMPRESSION_FIELD);
        map.put("Charset", CHARSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JsonFormatDescriptor, T> g) {
        return obj -> g.apply((JsonFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JsonFormatDescriptor> {
        /**
         * <p>
         * The level of compression of the source CSV file.
         * </p>
         * 
         * @param fileCompression
         *        The level of compression of the source CSV file.
         * @see JsonFileCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JsonFileCompression
         */
        Builder fileCompression(String fileCompression);

        /**
         * <p>
         * The level of compression of the source CSV file.
         * </p>
         * 
         * @param fileCompression
         *        The level of compression of the source CSV file.
         * @see JsonFileCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JsonFileCompression
         */
        Builder fileCompression(JsonFileCompression fileCompression);

        /**
         * <p>
         * The character set in which the source JSON file is written.
         * </p>
         * 
         * @param charset
         *        The character set in which the source JSON file is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(String charset);
    }

    static final class BuilderImpl implements Builder {
        private String fileCompression;

        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonFormatDescriptor model) {
            fileCompression(model.fileCompression);
            charset(model.charset);
        }

        public final String getFileCompression() {
            return fileCompression;
        }

        public final void setFileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
        }

        @Override
        public final Builder fileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        @Override
        public final Builder fileCompression(JsonFileCompression fileCompression) {
            this.fileCompression(fileCompression == null ? null : fileCompression.toString());
            return this;
        }

        public final String getCharset() {
            return charset;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        @Override
        public JsonFormatDescriptor build() {
            return new JsonFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
