/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A dimension name and value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionNameValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionNameValue.Builder, DimensionNameValue> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(DimensionNameValue::dimensionName)).setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValue").getter(getter(DimensionNameValue::dimensionValue))
            .setter(setter(Builder::dimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD,
            DIMENSION_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimensionName;

    private final String dimensionValue;

    private DimensionNameValue(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValue = builder.dimensionValue;
    }

    /**
     * <p>
     * The name of the dimension.
     * </p>
     * 
     * @return The name of the dimension.
     */
    public final String dimensionName() {
        return dimensionName;
    }

    /**
     * <p>
     * The value of the dimension.
     * </p>
     * 
     * @return The value of the dimension.
     */
    public final String dimensionValue() {
        return dimensionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionNameValue)) {
            return false;
        }
        DimensionNameValue other = (DimensionNameValue) obj;
        return Objects.equals(dimensionName(), other.dimensionName()) && Objects.equals(dimensionValue(), other.dimensionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionNameValue").add("DimensionName", dimensionName())
                .add("DimensionValue", dimensionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        case "DimensionValue":
            return Optional.ofNullable(clazz.cast(dimensionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DimensionName", DIMENSION_NAME_FIELD);
        map.put("DimensionValue", DIMENSION_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionNameValue, T> g) {
        return obj -> g.apply((DimensionNameValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionNameValue> {
        /**
         * <p>
         * The name of the dimension.
         * </p>
         * 
         * @param dimensionName
         *        The name of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * The value of the dimension.
         * </p>
         * 
         * @param dimensionValue
         *        The value of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValue(String dimensionValue);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionName;

        private String dimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionNameValue model) {
            dimensionName(model.dimensionName);
            dimensionValue(model.dimensionValue);
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final String getDimensionValue() {
            return dimensionValue;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        @Override
        public DimensionNameValue build() {
            return new DimensionNameValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
