/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An inferred dataset configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedMetricSetConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedMetricSetConfig.Builder, DetectedMetricSetConfig> {
    private static final SdkField<DetectedField> OFFSET_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("Offset").getter(getter(DetectedMetricSetConfig::offset)).setter(setter(Builder::offset))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final SdkField<DetectedField> METRIC_SET_FREQUENCY_FIELD = SdkField
            .<DetectedField> builder(MarshallingType.SDK_POJO).memberName("MetricSetFrequency")
            .getter(getter(DetectedMetricSetConfig::metricSetFrequency)).setter(setter(Builder::metricSetFrequency))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build())
            .build();

    private static final SdkField<DetectedMetricSource> METRIC_SOURCE_FIELD = SdkField
            .<DetectedMetricSource> builder(MarshallingType.SDK_POJO).memberName("MetricSource")
            .getter(getter(DetectedMetricSetConfig::metricSource)).setter(setter(Builder::metricSource))
            .constructor(DetectedMetricSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFSET_FIELD,
            METRIC_SET_FREQUENCY_FIELD, METRIC_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DetectedField offset;

    private final DetectedField metricSetFrequency;

    private final DetectedMetricSource metricSource;

    private DetectedMetricSetConfig(BuilderImpl builder) {
        this.offset = builder.offset;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.metricSource = builder.metricSource;
    }

    /**
     * <p>
     * The dataset's offset.
     * </p>
     * 
     * @return The dataset's offset.
     */
    public final DetectedField offset() {
        return offset;
    }

    /**
     * <p>
     * The dataset's interval.
     * </p>
     * 
     * @return The dataset's interval.
     */
    public final DetectedField metricSetFrequency() {
        return metricSetFrequency;
    }

    /**
     * <p>
     * The dataset's data source.
     * </p>
     * 
     * @return The dataset's data source.
     */
    public final DetectedMetricSource metricSource() {
        return metricSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(metricSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedMetricSetConfig)) {
            return false;
        }
        DetectedMetricSetConfig other = (DetectedMetricSetConfig) obj;
        return Objects.equals(offset(), other.offset()) && Objects.equals(metricSetFrequency(), other.metricSetFrequency())
                && Objects.equals(metricSource(), other.metricSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedMetricSetConfig").add("Offset", offset())
                .add("MetricSetFrequency", metricSetFrequency()).add("MetricSource", metricSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "MetricSetFrequency":
            return Optional.ofNullable(clazz.cast(metricSetFrequency()));
        case "MetricSource":
            return Optional.ofNullable(clazz.cast(metricSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Offset", OFFSET_FIELD);
        map.put("MetricSetFrequency", METRIC_SET_FREQUENCY_FIELD);
        map.put("MetricSource", METRIC_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectedMetricSetConfig, T> g) {
        return obj -> g.apply((DetectedMetricSetConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedMetricSetConfig> {
        /**
         * <p>
         * The dataset's offset.
         * </p>
         * 
         * @param offset
         *        The dataset's offset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(DetectedField offset);

        /**
         * <p>
         * The dataset's offset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #offset(DetectedField)}.
         * 
         * @param offset
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offset(DetectedField)
         */
        default Builder offset(Consumer<DetectedField.Builder> offset) {
            return offset(DetectedField.builder().applyMutation(offset).build());
        }

        /**
         * <p>
         * The dataset's interval.
         * </p>
         * 
         * @param metricSetFrequency
         *        The dataset's interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetFrequency(DetectedField metricSetFrequency);

        /**
         * <p>
         * The dataset's interval.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #metricSetFrequency(DetectedField)}.
         * 
         * @param metricSetFrequency
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSetFrequency(DetectedField)
         */
        default Builder metricSetFrequency(Consumer<DetectedField.Builder> metricSetFrequency) {
            return metricSetFrequency(DetectedField.builder().applyMutation(metricSetFrequency).build());
        }

        /**
         * <p>
         * The dataset's data source.
         * </p>
         * 
         * @param metricSource
         *        The dataset's data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSource(DetectedMetricSource metricSource);

        /**
         * <p>
         * The dataset's data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedMetricSource.Builder} avoiding
         * the need to create one manually via {@link DetectedMetricSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedMetricSource.Builder#build()} is called immediately and
         * its result is passed to {@link #metricSource(DetectedMetricSource)}.
         * 
         * @param metricSource
         *        a consumer that will call methods on {@link DetectedMetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSource(DetectedMetricSource)
         */
        default Builder metricSource(Consumer<DetectedMetricSource.Builder> metricSource) {
            return metricSource(DetectedMetricSource.builder().applyMutation(metricSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedField offset;

        private DetectedField metricSetFrequency;

        private DetectedMetricSource metricSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedMetricSetConfig model) {
            offset(model.offset);
            metricSetFrequency(model.metricSetFrequency);
            metricSource(model.metricSource);
        }

        public final DetectedField.Builder getOffset() {
            return offset != null ? offset.toBuilder() : null;
        }

        public final void setOffset(DetectedField.BuilderImpl offset) {
            this.offset = offset != null ? offset.build() : null;
        }

        @Override
        public final Builder offset(DetectedField offset) {
            this.offset = offset;
            return this;
        }

        public final DetectedField.Builder getMetricSetFrequency() {
            return metricSetFrequency != null ? metricSetFrequency.toBuilder() : null;
        }

        public final void setMetricSetFrequency(DetectedField.BuilderImpl metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency != null ? metricSetFrequency.build() : null;
        }

        @Override
        public final Builder metricSetFrequency(DetectedField metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        public final DetectedMetricSource.Builder getMetricSource() {
            return metricSource != null ? metricSource.toBuilder() : null;
        }

        public final void setMetricSource(DetectedMetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public final Builder metricSource(DetectedMetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        @Override
        public DetectedMetricSetConfig build() {
            return new DetectedMetricSetConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
