/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An inferred field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedField implements SdkPojo, Serializable, ToCopyableBuilder<DetectedField.Builder, DetectedField> {
    private static final SdkField<AttributeValue> VALUE_FIELD = SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(DetectedField::value)).setter(setter(Builder::value))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> CONFIDENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Confidence").getter(getter(DetectedField::confidenceAsString)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DetectedField::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, CONFIDENCE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AttributeValue value;

    private final String confidence;

    private final String message;

    private DetectedField(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
        this.message = builder.message;
    }

    /**
     * <p>
     * The field's value.
     * </p>
     * 
     * @return The field's value.
     */
    public final AttributeValue value() {
        return value;
    }

    /**
     * <p>
     * The field's confidence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidence} will
     * return {@link Confidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #confidenceAsString}.
     * </p>
     * 
     * @return The field's confidence.
     * @see Confidence
     */
    public final Confidence confidence() {
        return Confidence.fromValue(confidence);
    }

    /**
     * <p>
     * The field's confidence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidence} will
     * return {@link Confidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #confidenceAsString}.
     * </p>
     * 
     * @return The field's confidence.
     * @see Confidence
     */
    public final String confidenceAsString() {
        return confidence;
    }

    /**
     * <p>
     * The field's message.
     * </p>
     * 
     * @return The field's message.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedField)) {
            return false;
        }
        DetectedField other = (DetectedField) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(confidenceAsString(), other.confidenceAsString())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedField").add("Value", value()).add("Confidence", confidenceAsString())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidenceAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectedField, T> g) {
        return obj -> g.apply((DetectedField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedField> {
        /**
         * <p>
         * The field's value.
         * </p>
         * 
         * @param value
         *        The field's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(AttributeValue value);

        /**
         * <p>
         * The field's value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(AttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(AttributeValue)
         */
        default Builder value(Consumer<AttributeValue.Builder> value) {
            return value(AttributeValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The field's confidence.
         * </p>
         * 
         * @param confidence
         *        The field's confidence.
         * @see Confidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Confidence
         */
        Builder confidence(String confidence);

        /**
         * <p>
         * The field's confidence.
         * </p>
         * 
         * @param confidence
         *        The field's confidence.
         * @see Confidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Confidence
         */
        Builder confidence(Confidence confidence);

        /**
         * <p>
         * The field's message.
         * </p>
         * 
         * @param message
         *        The field's message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private AttributeValue value;

        private String confidence;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedField model) {
            value(model.value);
            confidence(model.confidence);
            message(model.message);
        }

        public final AttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(AttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final String getConfidence() {
            return confidence;
        }

        public final void setConfidence(String confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(String confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public final Builder confidence(Confidence confidence) {
            this.confidence(confidence == null ? null : confidence.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DetectedField build() {
            return new DetectedField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
