/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectMetricSetConfigResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<DetectMetricSetConfigResponse.Builder, DetectMetricSetConfigResponse> {
    private static final SdkField<DetectedMetricSetConfig> DETECTED_METRIC_SET_CONFIG_FIELD = SdkField
            .<DetectedMetricSetConfig> builder(MarshallingType.SDK_POJO).memberName("DetectedMetricSetConfig")
            .getter(getter(DetectMetricSetConfigResponse::detectedMetricSetConfig))
            .setter(setter(Builder::detectedMetricSetConfig)).constructor(DetectedMetricSetConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedMetricSetConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETECTED_METRIC_SET_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DetectedMetricSetConfig detectedMetricSetConfig;

    private DetectMetricSetConfigResponse(BuilderImpl builder) {
        super(builder);
        this.detectedMetricSetConfig = builder.detectedMetricSetConfig;
    }

    /**
     * <p>
     * The inferred dataset configuration for the datasource.
     * </p>
     * 
     * @return The inferred dataset configuration for the datasource.
     */
    public final DetectedMetricSetConfig detectedMetricSetConfig() {
        return detectedMetricSetConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectedMetricSetConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMetricSetConfigResponse)) {
            return false;
        }
        DetectMetricSetConfigResponse other = (DetectMetricSetConfigResponse) obj;
        return Objects.equals(detectedMetricSetConfig(), other.detectedMetricSetConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectMetricSetConfigResponse").add("DetectedMetricSetConfig", detectedMetricSetConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectedMetricSetConfig":
            return Optional.ofNullable(clazz.cast(detectedMetricSetConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DetectedMetricSetConfig", DETECTED_METRIC_SET_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectMetricSetConfigResponse, T> g) {
        return obj -> g.apply((DetectMetricSetConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectMetricSetConfigResponse> {
        /**
         * <p>
         * The inferred dataset configuration for the datasource.
         * </p>
         * 
         * @param detectedMetricSetConfig
         *        The inferred dataset configuration for the datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedMetricSetConfig(DetectedMetricSetConfig detectedMetricSetConfig);

        /**
         * <p>
         * The inferred dataset configuration for the datasource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedMetricSetConfig.Builder} avoiding
         * the need to create one manually via {@link DetectedMetricSetConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedMetricSetConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #detectedMetricSetConfig(DetectedMetricSetConfig)}.
         * 
         * @param detectedMetricSetConfig
         *        a consumer that will call methods on {@link DetectedMetricSetConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectedMetricSetConfig(DetectedMetricSetConfig)
         */
        default Builder detectedMetricSetConfig(Consumer<DetectedMetricSetConfig.Builder> detectedMetricSetConfig) {
            return detectedMetricSetConfig(DetectedMetricSetConfig.builder().applyMutation(detectedMetricSetConfig).build());
        }
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private DetectedMetricSetConfig detectedMetricSetConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMetricSetConfigResponse model) {
            super(model);
            detectedMetricSetConfig(model.detectedMetricSetConfig);
        }

        public final DetectedMetricSetConfig.Builder getDetectedMetricSetConfig() {
            return detectedMetricSetConfig != null ? detectedMetricSetConfig.toBuilder() : null;
        }

        public final void setDetectedMetricSetConfig(DetectedMetricSetConfig.BuilderImpl detectedMetricSetConfig) {
            this.detectedMetricSetConfig = detectedMetricSetConfig != null ? detectedMetricSetConfig.build() : null;
        }

        @Override
        public final Builder detectedMetricSetConfig(DetectedMetricSetConfig detectedMetricSetConfig) {
            this.detectedMetricSetConfig = detectedMetricSetConfig;
            return this;
        }

        @Override
        public DetectMetricSetConfigResponse build() {
            return new DetectMetricSetConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
