/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for backtest mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackTestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BackTestConfiguration.Builder, BackTestConfiguration> {
    private static final SdkField<Boolean> RUN_BACK_TEST_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RunBackTestMode").getter(getter(BackTestConfiguration::runBackTestMode))
            .setter(setter(Builder::runBackTestMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunBackTestMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_BACK_TEST_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean runBackTestMode;

    private BackTestConfiguration(BuilderImpl builder) {
        this.runBackTestMode = builder.runBackTestMode;
    }

    /**
     * <p>
     * Run a backtest instead of monitoring new data.
     * </p>
     * 
     * @return Run a backtest instead of monitoring new data.
     */
    public final Boolean runBackTestMode() {
        return runBackTestMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runBackTestMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackTestConfiguration)) {
            return false;
        }
        BackTestConfiguration other = (BackTestConfiguration) obj;
        return Objects.equals(runBackTestMode(), other.runBackTestMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackTestConfiguration").add("RunBackTestMode", runBackTestMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunBackTestMode":
            return Optional.ofNullable(clazz.cast(runBackTestMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RunBackTestMode", RUN_BACK_TEST_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackTestConfiguration, T> g) {
        return obj -> g.apply((BackTestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackTestConfiguration> {
        /**
         * <p>
         * Run a backtest instead of monitoring new data.
         * </p>
         * 
         * @param runBackTestMode
         *        Run a backtest instead of monitoring new data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runBackTestMode(Boolean runBackTestMode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean runBackTestMode;

        private BuilderImpl() {
        }

        private BuilderImpl(BackTestConfiguration model) {
            runBackTestMode(model.runBackTestMode);
        }

        public final Boolean getRunBackTestMode() {
            return runBackTestMode;
        }

        public final void setRunBackTestMode(Boolean runBackTestMode) {
            this.runBackTestMode = runBackTestMode;
        }

        @Override
        public final Builder runBackTestMode(Boolean runBackTestMode) {
            this.runBackTestMode = runBackTestMode;
            return this;
        }

        @Override
        public BackTestConfiguration build() {
            return new BackTestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
