/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An auto detection source config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoDetectionS3SourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoDetectionS3SourceConfig.Builder, AutoDetectionS3SourceConfig> {
    private static final SdkField<List<String>> TEMPLATED_PATH_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TemplatedPathList")
            .getter(getter(AutoDetectionS3SourceConfig::templatedPathList))
            .setter(setter(Builder::templatedPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HISTORICAL_DATA_PATH_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HistoricalDataPathList")
            .getter(getter(AutoDetectionS3SourceConfig::historicalDataPathList))
            .setter(setter(Builder::historicalDataPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalDataPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATED_PATH_LIST_FIELD,
            HISTORICAL_DATA_PATH_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> templatedPathList;

    private final List<String> historicalDataPathList;

    private AutoDetectionS3SourceConfig(BuilderImpl builder) {
        this.templatedPathList = builder.templatedPathList;
        this.historicalDataPathList = builder.historicalDataPathList;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplatedPathList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplatedPathList() {
        return templatedPathList != null && !(templatedPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The config's templated path list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplatedPathList} method.
     * </p>
     * 
     * @return The config's templated path list.
     */
    public final List<String> templatedPathList() {
        return templatedPathList;
    }

    /**
     * For responses, this returns true if the service returned a value for the HistoricalDataPathList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHistoricalDataPathList() {
        return historicalDataPathList != null && !(historicalDataPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The config's historical data path list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHistoricalDataPathList} method.
     * </p>
     * 
     * @return The config's historical data path list.
     */
    public final List<String> historicalDataPathList() {
        return historicalDataPathList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplatedPathList() ? templatedPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHistoricalDataPathList() ? historicalDataPathList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDetectionS3SourceConfig)) {
            return false;
        }
        AutoDetectionS3SourceConfig other = (AutoDetectionS3SourceConfig) obj;
        return hasTemplatedPathList() == other.hasTemplatedPathList()
                && Objects.equals(templatedPathList(), other.templatedPathList())
                && hasHistoricalDataPathList() == other.hasHistoricalDataPathList()
                && Objects.equals(historicalDataPathList(), other.historicalDataPathList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoDetectionS3SourceConfig")
                .add("TemplatedPathList", hasTemplatedPathList() ? templatedPathList() : null)
                .add("HistoricalDataPathList", hasHistoricalDataPathList() ? historicalDataPathList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplatedPathList":
            return Optional.ofNullable(clazz.cast(templatedPathList()));
        case "HistoricalDataPathList":
            return Optional.ofNullable(clazz.cast(historicalDataPathList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplatedPathList", TEMPLATED_PATH_LIST_FIELD);
        map.put("HistoricalDataPathList", HISTORICAL_DATA_PATH_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoDetectionS3SourceConfig, T> g) {
        return obj -> g.apply((AutoDetectionS3SourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoDetectionS3SourceConfig> {
        /**
         * <p>
         * The config's templated path list.
         * </p>
         * 
         * @param templatedPathList
         *        The config's templated path list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatedPathList(Collection<String> templatedPathList);

        /**
         * <p>
         * The config's templated path list.
         * </p>
         * 
         * @param templatedPathList
         *        The config's templated path list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatedPathList(String... templatedPathList);

        /**
         * <p>
         * The config's historical data path list.
         * </p>
         * 
         * @param historicalDataPathList
         *        The config's historical data path list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalDataPathList(Collection<String> historicalDataPathList);

        /**
         * <p>
         * The config's historical data path list.
         * </p>
         * 
         * @param historicalDataPathList
         *        The config's historical data path list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalDataPathList(String... historicalDataPathList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> templatedPathList = DefaultSdkAutoConstructList.getInstance();

        private List<String> historicalDataPathList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDetectionS3SourceConfig model) {
            templatedPathList(model.templatedPathList);
            historicalDataPathList(model.historicalDataPathList);
        }

        public final Collection<String> getTemplatedPathList() {
            if (templatedPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return templatedPathList;
        }

        public final void setTemplatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
        }

        @Override
        public final Builder templatedPathList(Collection<String> templatedPathList) {
            this.templatedPathList = TemplatedPathListCopier.copy(templatedPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatedPathList(String... templatedPathList) {
            templatedPathList(Arrays.asList(templatedPathList));
            return this;
        }

        public final Collection<String> getHistoricalDataPathList() {
            if (historicalDataPathList instanceof SdkAutoConstructList) {
                return null;
            }
            return historicalDataPathList;
        }

        public final void setHistoricalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
        }

        @Override
        public final Builder historicalDataPathList(Collection<String> historicalDataPathList) {
            this.historicalDataPathList = HistoricalDataPathListCopier.copy(historicalDataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalDataPathList(String... historicalDataPathList) {
            historicalDataPathList(Arrays.asList(historicalDataPathList));
            return this;
        }

        @Override
        public AutoDetectionS3SourceConfig build() {
            return new AutoDetectionS3SourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
