/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of an alert's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlertSummary implements SdkPojo, Serializable, ToCopyableBuilder<AlertSummary.Builder, AlertSummary> {
    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertArn").getter(getter(AlertSummary::alertArn)).setter(setter(Builder::alertArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(AlertSummary::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertName").getter(getter(AlertSummary::alertName)).setter(setter(Builder::alertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()).build();

    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AlertSensitivityThreshold")
            .getter(getter(AlertSummary::alertSensitivityThreshold)).setter(setter(Builder::alertSensitivityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build())
            .build();

    private static final SdkField<String> ALERT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertType").getter(getter(AlertSummary::alertTypeAsString)).setter(setter(Builder::alertType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertType").build()).build();

    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertStatus").getter(getter(AlertSummary::alertStatusAsString)).setter(setter(Builder::alertStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(AlertSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AlertSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(AlertSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_ARN_FIELD,
            ANOMALY_DETECTOR_ARN_FIELD, ALERT_NAME_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_TYPE_FIELD,
            ALERT_STATUS_FIELD, LAST_MODIFICATION_TIME_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alertArn;

    private final String anomalyDetectorArn;

    private final String alertName;

    private final Integer alertSensitivityThreshold;

    private final String alertType;

    private final String alertStatus;

    private final Instant lastModificationTime;

    private final Instant creationTime;

    private final Map<String, String> tags;

    private AlertSummary(BuilderImpl builder) {
        this.alertArn = builder.alertArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertType = builder.alertType;
        this.alertStatus = builder.alertStatus;
        this.lastModificationTime = builder.lastModificationTime;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the alert.
     * </p>
     * 
     * @return The ARN of the alert.
     */
    public final String alertArn() {
        return alertArn;
    }

    /**
     * <p>
     * The ARN of the detector to which the alert is attached.
     * </p>
     * 
     * @return The ARN of the detector to which the alert is attached.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The name of the alert.
     * </p>
     * 
     * @return The name of the alert.
     */
    public final String alertName() {
        return alertName;
    }

    /**
     * <p>
     * The minimum severity for an anomaly to trigger the alert.
     * </p>
     * 
     * @return The minimum severity for an anomaly to trigger the alert.
     */
    public final Integer alertSensitivityThreshold() {
        return alertSensitivityThreshold;
    }

    /**
     * <p>
     * The type of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertType} will
     * return {@link AlertType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertTypeAsString}.
     * </p>
     * 
     * @return The type of the alert.
     * @see AlertType
     */
    public final AlertType alertType() {
        return AlertType.fromValue(alertType);
    }

    /**
     * <p>
     * The type of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertType} will
     * return {@link AlertType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertTypeAsString}.
     * </p>
     * 
     * @return The type of the alert.
     * @see AlertType
     */
    public final String alertTypeAsString() {
        return alertType;
    }

    /**
     * <p>
     * The status of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link AlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status of the alert.
     * @see AlertStatus
     */
    public final AlertStatus alertStatus() {
        return AlertStatus.fromValue(alertStatus);
    }

    /**
     * <p>
     * The status of the alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link AlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The status of the alert.
     * @see AlertStatus
     */
    public final String alertStatusAsString() {
        return alertStatus;
    }

    /**
     * <p>
     * The time at which the alert was last modified.
     * </p>
     * 
     * @return The time at which the alert was last modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The time at which the alert was created.
     * </p>
     * 
     * @return The time at which the alert was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(alertName());
        hashCode = 31 * hashCode + Objects.hashCode(alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(alertTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertSummary)) {
            return false;
        }
        AlertSummary other = (AlertSummary) obj;
        return Objects.equals(alertArn(), other.alertArn()) && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(alertName(), other.alertName())
                && Objects.equals(alertSensitivityThreshold(), other.alertSensitivityThreshold())
                && Objects.equals(alertTypeAsString(), other.alertTypeAsString())
                && Objects.equals(alertStatusAsString(), other.alertStatusAsString())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(creationTime(), other.creationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlertSummary").add("AlertArn", alertArn()).add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("AlertName", alertName()).add("AlertSensitivityThreshold", alertSensitivityThreshold())
                .add("AlertType", alertTypeAsString()).add("AlertStatus", alertStatusAsString())
                .add("LastModificationTime", lastModificationTime()).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlertArn":
            return Optional.ofNullable(clazz.cast(alertArn()));
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "AlertName":
            return Optional.ofNullable(clazz.cast(alertName()));
        case "AlertSensitivityThreshold":
            return Optional.ofNullable(clazz.cast(alertSensitivityThreshold()));
        case "AlertType":
            return Optional.ofNullable(clazz.cast(alertTypeAsString()));
        case "AlertStatus":
            return Optional.ofNullable(clazz.cast(alertStatusAsString()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlertArn", ALERT_ARN_FIELD);
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("AlertName", ALERT_NAME_FIELD);
        map.put("AlertSensitivityThreshold", ALERT_SENSITIVITY_THRESHOLD_FIELD);
        map.put("AlertType", ALERT_TYPE_FIELD);
        map.put("AlertStatus", ALERT_STATUS_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlertSummary, T> g) {
        return obj -> g.apply((AlertSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlertSummary> {
        /**
         * <p>
         * The ARN of the alert.
         * </p>
         * 
         * @param alertArn
         *        The ARN of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertArn(String alertArn);

        /**
         * <p>
         * The ARN of the detector to which the alert is attached.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector to which the alert is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The name of the alert.
         * </p>
         * 
         * @param alertName
         *        The name of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertName(String alertName);

        /**
         * <p>
         * The minimum severity for an anomaly to trigger the alert.
         * </p>
         * 
         * @param alertSensitivityThreshold
         *        The minimum severity for an anomaly to trigger the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSensitivityThreshold(Integer alertSensitivityThreshold);

        /**
         * <p>
         * The type of the alert.
         * </p>
         * 
         * @param alertType
         *        The type of the alert.
         * @see AlertType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertType
         */
        Builder alertType(String alertType);

        /**
         * <p>
         * The type of the alert.
         * </p>
         * 
         * @param alertType
         *        The type of the alert.
         * @see AlertType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertType
         */
        Builder alertType(AlertType alertType);

        /**
         * <p>
         * The status of the alert.
         * </p>
         * 
         * @param alertStatus
         *        The status of the alert.
         * @see AlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertStatus
         */
        Builder alertStatus(String alertStatus);

        /**
         * <p>
         * The status of the alert.
         * </p>
         * 
         * @param alertStatus
         *        The status of the alert.
         * @see AlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlertStatus
         */
        Builder alertStatus(AlertStatus alertStatus);

        /**
         * <p>
         * The time at which the alert was last modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The time at which the alert was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The time at which the alert was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the alert was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
         * </p>
         * 
         * @param tags
         *        The alert's <a
         *        href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String alertArn;

        private String anomalyDetectorArn;

        private String alertName;

        private Integer alertSensitivityThreshold;

        private String alertType;

        private String alertStatus;

        private Instant lastModificationTime;

        private Instant creationTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlertSummary model) {
            alertArn(model.alertArn);
            anomalyDetectorArn(model.anomalyDetectorArn);
            alertName(model.alertName);
            alertSensitivityThreshold(model.alertSensitivityThreshold);
            alertType(model.alertType);
            alertStatus(model.alertStatus);
            lastModificationTime(model.lastModificationTime);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getAlertArn() {
            return alertArn;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        @Override
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAlertName() {
            return alertName;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        @Override
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final String getAlertType() {
            return alertType;
        }

        public final void setAlertType(String alertType) {
            this.alertType = alertType;
        }

        @Override
        public final Builder alertType(String alertType) {
            this.alertType = alertType;
            return this;
        }

        @Override
        public final Builder alertType(AlertType alertType) {
            this.alertType(alertType == null ? null : alertType.toString());
            return this;
        }

        public final String getAlertStatus() {
            return alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(AlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public AlertSummary build() {
            return new AlertSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
