/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the alert filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlertFilters implements SdkPojo, Serializable, ToCopyableBuilder<AlertFilters.Builder, AlertFilters> {
    private static final SdkField<List<String>> METRIC_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricList")
            .getter(getter(AlertFilters::metricList))
            .setter(setter(Builder::metricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionFilter>> DIMENSION_FILTER_LIST_FIELD = SdkField
            .<List<DimensionFilter>> builder(MarshallingType.LIST)
            .memberName("DimensionFilterList")
            .getter(getter(AlertFilters::dimensionFilterList))
            .setter(setter(Builder::dimensionFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionFilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_LIST_FIELD,
            DIMENSION_FILTER_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> metricList;

    private final List<DimensionFilter> dimensionFilterList;

    private AlertFilters(BuilderImpl builder) {
        this.metricList = builder.metricList;
        this.dimensionFilterList = builder.dimensionFilterList;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetricList() {
        return metricList != null && !(metricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of measures that you want to get alerts for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricList} method.
     * </p>
     * 
     * @return The list of measures that you want to get alerts for.
     */
    public final List<String> metricList() {
        return metricList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionFilterList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionFilterList() {
        return dimensionFilterList != null && !(dimensionFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of DimensionFilter objects that are used for dimension-based filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionFilterList} method.
     * </p>
     * 
     * @return The list of DimensionFilter objects that are used for dimension-based filtering.
     */
    public final List<DimensionFilter> dimensionFilterList() {
        return dimensionFilterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricList() ? metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionFilterList() ? dimensionFilterList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertFilters)) {
            return false;
        }
        AlertFilters other = (AlertFilters) obj;
        return hasMetricList() == other.hasMetricList() && Objects.equals(metricList(), other.metricList())
                && hasDimensionFilterList() == other.hasDimensionFilterList()
                && Objects.equals(dimensionFilterList(), other.dimensionFilterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlertFilters").add("MetricList", hasMetricList() ? metricList() : null)
                .add("DimensionFilterList", hasDimensionFilterList() ? dimensionFilterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricList":
            return Optional.ofNullable(clazz.cast(metricList()));
        case "DimensionFilterList":
            return Optional.ofNullable(clazz.cast(dimensionFilterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricList", METRIC_LIST_FIELD);
        map.put("DimensionFilterList", DIMENSION_FILTER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlertFilters, T> g) {
        return obj -> g.apply((AlertFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlertFilters> {
        /**
         * <p>
         * The list of measures that you want to get alerts for.
         * </p>
         * 
         * @param metricList
         *        The list of measures that you want to get alerts for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Collection<String> metricList);

        /**
         * <p>
         * The list of measures that you want to get alerts for.
         * </p>
         * 
         * @param metricList
         *        The list of measures that you want to get alerts for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(String... metricList);

        /**
         * <p>
         * The list of DimensionFilter objects that are used for dimension-based filtering.
         * </p>
         * 
         * @param dimensionFilterList
         *        The list of DimensionFilter objects that are used for dimension-based filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionFilterList(Collection<DimensionFilter> dimensionFilterList);

        /**
         * <p>
         * The list of DimensionFilter objects that are used for dimension-based filtering.
         * </p>
         * 
         * @param dimensionFilterList
         *        The list of DimensionFilter objects that are used for dimension-based filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionFilterList(DimensionFilter... dimensionFilterList);

        /**
         * <p>
         * The list of DimensionFilter objects that are used for dimension-based filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #dimensionFilterList(List<DimensionFilter>)}.
         * 
         * @param dimensionFilterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionFilterList(java.util.Collection<DimensionFilter>)
         */
        Builder dimensionFilterList(Consumer<DimensionFilter.Builder>... dimensionFilterList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> metricList = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionFilter> dimensionFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlertFilters model) {
            metricList(model.metricList);
            dimensionFilterList(model.dimensionFilterList);
        }

        public final Collection<String> getMetricList() {
            if (metricList instanceof SdkAutoConstructList) {
                return null;
            }
            return metricList;
        }

        public final void setMetricList(Collection<String> metricList) {
            this.metricList = MetricNameListCopier.copy(metricList);
        }

        @Override
        public final Builder metricList(Collection<String> metricList) {
            this.metricList = MetricNameListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(String... metricList) {
            metricList(Arrays.asList(metricList));
            return this;
        }

        public final List<DimensionFilter.Builder> getDimensionFilterList() {
            List<DimensionFilter.Builder> result = DimensionFilterListCopier.copyToBuilder(this.dimensionFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionFilterList(Collection<DimensionFilter.BuilderImpl> dimensionFilterList) {
            this.dimensionFilterList = DimensionFilterListCopier.copyFromBuilder(dimensionFilterList);
        }

        @Override
        public final Builder dimensionFilterList(Collection<DimensionFilter> dimensionFilterList) {
            this.dimensionFilterList = DimensionFilterListCopier.copy(dimensionFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(DimensionFilter... dimensionFilterList) {
            dimensionFilterList(Arrays.asList(dimensionFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(Consumer<DimensionFilter.Builder>... dimensionFilterList) {
            dimensionFilterList(Stream.of(dimensionFilterList).map(c -> DimensionFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AlertFilters build() {
            return new AlertFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
