/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AppFlowConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.AthenaSourceConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.CloudWatchConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.RDSSourceConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.RedshiftSourceConfig;
import software.amazon.awssdk.services.lookoutmetrics.model.S3SourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSource> {
    private static final SdkField<S3SourceConfig> S3_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3SourceConfig").getter(MetricSource.getter(MetricSource::s3SourceConfig)).setter(MetricSource.setter(Builder::s3SourceConfig)).constructor(S3SourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SourceConfig").build()}).build();
    private static final SdkField<AppFlowConfig> APP_FLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppFlowConfig").getter(MetricSource.getter(MetricSource::appFlowConfig)).setter(MetricSource.setter(Builder::appFlowConfig)).constructor(AppFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppFlowConfig").build()}).build();
    private static final SdkField<CloudWatchConfig> CLOUD_WATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchConfig").getter(MetricSource.getter(MetricSource::cloudWatchConfig)).setter(MetricSource.setter(Builder::cloudWatchConfig)).constructor(CloudWatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchConfig").build()}).build();
    private static final SdkField<RDSSourceConfig> RDS_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RDSSourceConfig").getter(MetricSource.getter(MetricSource::rdsSourceConfig)).setter(MetricSource.setter(Builder::rdsSourceConfig)).constructor(RDSSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RDSSourceConfig").build()}).build();
    private static final SdkField<RedshiftSourceConfig> REDSHIFT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftSourceConfig").getter(MetricSource.getter(MetricSource::redshiftSourceConfig)).setter(MetricSource.setter(Builder::redshiftSourceConfig)).constructor(RedshiftSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSourceConfig").build()}).build();
    private static final SdkField<AthenaSourceConfig> ATHENA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AthenaSourceConfig").getter(MetricSource.getter(MetricSource::athenaSourceConfig)).setter(MetricSource.setter(Builder::athenaSourceConfig)).constructor(AthenaSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaSourceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_SOURCE_CONFIG_FIELD, APP_FLOW_CONFIG_FIELD, CLOUD_WATCH_CONFIG_FIELD, RDS_SOURCE_CONFIG_FIELD, REDSHIFT_SOURCE_CONFIG_FIELD, ATHENA_SOURCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3SourceConfig s3SourceConfig;
    private final AppFlowConfig appFlowConfig;
    private final CloudWatchConfig cloudWatchConfig;
    private final RDSSourceConfig rdsSourceConfig;
    private final RedshiftSourceConfig redshiftSourceConfig;
    private final AthenaSourceConfig athenaSourceConfig;

    private MetricSource(BuilderImpl builder) {
        this.s3SourceConfig = builder.s3SourceConfig;
        this.appFlowConfig = builder.appFlowConfig;
        this.cloudWatchConfig = builder.cloudWatchConfig;
        this.rdsSourceConfig = builder.rdsSourceConfig;
        this.redshiftSourceConfig = builder.redshiftSourceConfig;
        this.athenaSourceConfig = builder.athenaSourceConfig;
    }

    public final S3SourceConfig s3SourceConfig() {
        return this.s3SourceConfig;
    }

    public final AppFlowConfig appFlowConfig() {
        return this.appFlowConfig;
    }

    public final CloudWatchConfig cloudWatchConfig() {
        return this.cloudWatchConfig;
    }

    public final RDSSourceConfig rdsSourceConfig() {
        return this.rdsSourceConfig;
    }

    public final RedshiftSourceConfig redshiftSourceConfig() {
        return this.redshiftSourceConfig;
    }

    public final AthenaSourceConfig athenaSourceConfig() {
        return this.athenaSourceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.appFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaSourceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSource)) {
            return false;
        }
        MetricSource other = (MetricSource)obj;
        return Objects.equals(this.s3SourceConfig(), other.s3SourceConfig()) && Objects.equals(this.appFlowConfig(), other.appFlowConfig()) && Objects.equals(this.cloudWatchConfig(), other.cloudWatchConfig()) && Objects.equals(this.rdsSourceConfig(), other.rdsSourceConfig()) && Objects.equals(this.redshiftSourceConfig(), other.redshiftSourceConfig()) && Objects.equals(this.athenaSourceConfig(), other.athenaSourceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSource").add("S3SourceConfig", (Object)this.s3SourceConfig()).add("AppFlowConfig", (Object)this.appFlowConfig()).add("CloudWatchConfig", (Object)this.cloudWatchConfig()).add("RDSSourceConfig", (Object)this.rdsSourceConfig()).add("RedshiftSourceConfig", (Object)this.redshiftSourceConfig()).add("AthenaSourceConfig", (Object)this.athenaSourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3SourceConfig": {
                return Optional.ofNullable(clazz.cast(this.s3SourceConfig()));
            }
            case "AppFlowConfig": {
                return Optional.ofNullable(clazz.cast(this.appFlowConfig()));
            }
            case "CloudWatchConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchConfig()));
            }
            case "RDSSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.rdsSourceConfig()));
            }
            case "RedshiftSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.redshiftSourceConfig()));
            }
            case "AthenaSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.athenaSourceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3SourceConfig", S3_SOURCE_CONFIG_FIELD);
        map.put("AppFlowConfig", APP_FLOW_CONFIG_FIELD);
        map.put("CloudWatchConfig", CLOUD_WATCH_CONFIG_FIELD);
        map.put("RDSSourceConfig", RDS_SOURCE_CONFIG_FIELD);
        map.put("RedshiftSourceConfig", REDSHIFT_SOURCE_CONFIG_FIELD);
        map.put("AthenaSourceConfig", ATHENA_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSource, T> g) {
        return obj -> g.apply((MetricSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3SourceConfig s3SourceConfig;
        private AppFlowConfig appFlowConfig;
        private CloudWatchConfig cloudWatchConfig;
        private RDSSourceConfig rdsSourceConfig;
        private RedshiftSourceConfig redshiftSourceConfig;
        private AthenaSourceConfig athenaSourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSource model) {
            this.s3SourceConfig(model.s3SourceConfig);
            this.appFlowConfig(model.appFlowConfig);
            this.cloudWatchConfig(model.cloudWatchConfig);
            this.rdsSourceConfig(model.rdsSourceConfig);
            this.redshiftSourceConfig(model.redshiftSourceConfig);
            this.athenaSourceConfig(model.athenaSourceConfig);
        }

        public final S3SourceConfig.Builder getS3SourceConfig() {
            return this.s3SourceConfig != null ? this.s3SourceConfig.toBuilder() : null;
        }

        public final void setS3SourceConfig(S3SourceConfig.BuilderImpl s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig != null ? s3SourceConfig.build() : null;
        }

        @Override
        public final Builder s3SourceConfig(S3SourceConfig s3SourceConfig) {
            this.s3SourceConfig = s3SourceConfig;
            return this;
        }

        public final AppFlowConfig.Builder getAppFlowConfig() {
            return this.appFlowConfig != null ? this.appFlowConfig.toBuilder() : null;
        }

        public final void setAppFlowConfig(AppFlowConfig.BuilderImpl appFlowConfig) {
            this.appFlowConfig = appFlowConfig != null ? appFlowConfig.build() : null;
        }

        @Override
        public final Builder appFlowConfig(AppFlowConfig appFlowConfig) {
            this.appFlowConfig = appFlowConfig;
            return this;
        }

        public final CloudWatchConfig.Builder getCloudWatchConfig() {
            return this.cloudWatchConfig != null ? this.cloudWatchConfig.toBuilder() : null;
        }

        public final void setCloudWatchConfig(CloudWatchConfig.BuilderImpl cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig != null ? cloudWatchConfig.build() : null;
        }

        @Override
        public final Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig;
            return this;
        }

        public final RDSSourceConfig.Builder getRdsSourceConfig() {
            return this.rdsSourceConfig != null ? this.rdsSourceConfig.toBuilder() : null;
        }

        public final void setRdsSourceConfig(RDSSourceConfig.BuilderImpl rdsSourceConfig) {
            this.rdsSourceConfig = rdsSourceConfig != null ? rdsSourceConfig.build() : null;
        }

        @Override
        public final Builder rdsSourceConfig(RDSSourceConfig rdsSourceConfig) {
            this.rdsSourceConfig = rdsSourceConfig;
            return this;
        }

        public final RedshiftSourceConfig.Builder getRedshiftSourceConfig() {
            return this.redshiftSourceConfig != null ? this.redshiftSourceConfig.toBuilder() : null;
        }

        public final void setRedshiftSourceConfig(RedshiftSourceConfig.BuilderImpl redshiftSourceConfig) {
            this.redshiftSourceConfig = redshiftSourceConfig != null ? redshiftSourceConfig.build() : null;
        }

        @Override
        public final Builder redshiftSourceConfig(RedshiftSourceConfig redshiftSourceConfig) {
            this.redshiftSourceConfig = redshiftSourceConfig;
            return this;
        }

        public final AthenaSourceConfig.Builder getAthenaSourceConfig() {
            return this.athenaSourceConfig != null ? this.athenaSourceConfig.toBuilder() : null;
        }

        public final void setAthenaSourceConfig(AthenaSourceConfig.BuilderImpl athenaSourceConfig) {
            this.athenaSourceConfig = athenaSourceConfig != null ? athenaSourceConfig.build() : null;
        }

        @Override
        public final Builder athenaSourceConfig(AthenaSourceConfig athenaSourceConfig) {
            this.athenaSourceConfig = athenaSourceConfig;
            return this;
        }

        public MetricSource build() {
            return new MetricSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSource> {
        public Builder s3SourceConfig(S3SourceConfig var1);

        default public Builder s3SourceConfig(Consumer<S3SourceConfig.Builder> s3SourceConfig) {
            return this.s3SourceConfig((S3SourceConfig)((S3SourceConfig.Builder)S3SourceConfig.builder().applyMutation(s3SourceConfig)).build());
        }

        public Builder appFlowConfig(AppFlowConfig var1);

        default public Builder appFlowConfig(Consumer<AppFlowConfig.Builder> appFlowConfig) {
            return this.appFlowConfig((AppFlowConfig)((AppFlowConfig.Builder)AppFlowConfig.builder().applyMutation(appFlowConfig)).build());
        }

        public Builder cloudWatchConfig(CloudWatchConfig var1);

        default public Builder cloudWatchConfig(Consumer<CloudWatchConfig.Builder> cloudWatchConfig) {
            return this.cloudWatchConfig((CloudWatchConfig)((CloudWatchConfig.Builder)CloudWatchConfig.builder().applyMutation(cloudWatchConfig)).build());
        }

        public Builder rdsSourceConfig(RDSSourceConfig var1);

        default public Builder rdsSourceConfig(Consumer<RDSSourceConfig.Builder> rdsSourceConfig) {
            return this.rdsSourceConfig((RDSSourceConfig)((RDSSourceConfig.Builder)RDSSourceConfig.builder().applyMutation(rdsSourceConfig)).build());
        }

        public Builder redshiftSourceConfig(RedshiftSourceConfig var1);

        default public Builder redshiftSourceConfig(Consumer<RedshiftSourceConfig.Builder> redshiftSourceConfig) {
            return this.redshiftSourceConfig((RedshiftSourceConfig)((RedshiftSourceConfig.Builder)RedshiftSourceConfig.builder().applyMutation(redshiftSourceConfig)).build());
        }

        public Builder athenaSourceConfig(AthenaSourceConfig var1);

        default public Builder athenaSourceConfig(Consumer<AthenaSourceConfig.Builder> athenaSourceConfig) {
            return this.athenaSourceConfig((AthenaSourceConfig)((AthenaSourceConfig.Builder)AthenaSourceConfig.builder().applyMutation(athenaSourceConfig)).build());
        }
    }
}

