/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AutoDetectionMetricSource;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectMetricSetConfigRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, DetectMetricSetConfigRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(DetectMetricSetConfigRequest.getter(DetectMetricSetConfigRequest::anomalyDetectorArn)).setter(DetectMetricSetConfigRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<AutoDetectionMetricSource> AUTO_DETECTION_METRIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoDetectionMetricSource").getter(DetectMetricSetConfigRequest.getter(DetectMetricSetConfigRequest::autoDetectionMetricSource)).setter(DetectMetricSetConfigRequest.setter(Builder::autoDetectionMetricSource)).constructor(AutoDetectionMetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDetectionMetricSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, AUTO_DETECTION_METRIC_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
            this.put("AutoDetectionMetricSource", AUTO_DETECTION_METRIC_SOURCE_FIELD);
        }
    });
    private final String anomalyDetectorArn;
    private final AutoDetectionMetricSource autoDetectionMetricSource;

    private DetectMetricSetConfigRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.autoDetectionMetricSource = builder.autoDetectionMetricSource;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final AutoDetectionMetricSource autoDetectionMetricSource() {
        return this.autoDetectionMetricSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDetectionMetricSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMetricSetConfigRequest)) {
            return false;
        }
        DetectMetricSetConfigRequest other = (DetectMetricSetConfigRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.autoDetectionMetricSource(), other.autoDetectionMetricSource());
    }

    public final String toString() {
        return ToString.builder((String)"DetectMetricSetConfigRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AutoDetectionMetricSource", (Object)this.autoDetectionMetricSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AutoDetectionMetricSource": {
                return Optional.ofNullable(clazz.cast(this.autoDetectionMetricSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectMetricSetConfigRequest, T> g) {
        return obj -> g.apply((DetectMetricSetConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private AutoDetectionMetricSource autoDetectionMetricSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMetricSetConfigRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.autoDetectionMetricSource(model.autoDetectionMetricSource);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final AutoDetectionMetricSource.Builder getAutoDetectionMetricSource() {
            return this.autoDetectionMetricSource != null ? this.autoDetectionMetricSource.toBuilder() : null;
        }

        public final void setAutoDetectionMetricSource(AutoDetectionMetricSource.BuilderImpl autoDetectionMetricSource) {
            this.autoDetectionMetricSource = autoDetectionMetricSource != null ? autoDetectionMetricSource.build() : null;
        }

        @Override
        public final Builder autoDetectionMetricSource(AutoDetectionMetricSource autoDetectionMetricSource) {
            this.autoDetectionMetricSource = autoDetectionMetricSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectMetricSetConfigRequest build() {
            return new DetectMetricSetConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectMetricSetConfigRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder autoDetectionMetricSource(AutoDetectionMetricSource var1);

        default public Builder autoDetectionMetricSource(Consumer<AutoDetectionMetricSource.Builder> autoDetectionMetricSource) {
            return this.autoDetectionMetricSource((AutoDetectionMetricSource)((AutoDetectionMetricSource.Builder)AutoDetectionMetricSource.builder().applyMutation(autoDetectionMetricSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

