/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.ExecutionListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.ExecutionStatus;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyDetectionExecutionsResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, DescribeAnomalyDetectionExecutionsResponse> {
    private static final SdkField<List<ExecutionStatus>> EXECUTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExecutionList").getter(DescribeAnomalyDetectionExecutionsResponse.getter(DescribeAnomalyDetectionExecutionsResponse::executionList)).setter(DescribeAnomalyDetectionExecutionsResponse.setter(Builder::executionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAnomalyDetectionExecutionsResponse.getter(DescribeAnomalyDetectionExecutionsResponse::nextToken)).setter(DescribeAnomalyDetectionExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExecutionList", EXECUTION_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ExecutionStatus> executionList;
    private final String nextToken;

    private DescribeAnomalyDetectionExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionList = builder.executionList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExecutionList() {
        return this.executionList != null && !(this.executionList instanceof SdkAutoConstructList);
    }

    public final List<ExecutionStatus> executionList() {
        return this.executionList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionList() ? this.executionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectionExecutionsResponse)) {
            return false;
        }
        DescribeAnomalyDetectionExecutionsResponse other = (DescribeAnomalyDetectionExecutionsResponse)((Object)obj);
        return this.hasExecutionList() == other.hasExecutionList() && Objects.equals(this.executionList(), other.executionList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnomalyDetectionExecutionsResponse").add("ExecutionList", this.hasExecutionList() ? this.executionList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionList": {
                return Optional.ofNullable(clazz.cast(this.executionList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectionExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectionExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<ExecutionStatus> executionList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectionExecutionsResponse model) {
            super(model);
            this.executionList(model.executionList);
            this.nextToken(model.nextToken);
        }

        public final List<ExecutionStatus.Builder> getExecutionList() {
            List<ExecutionStatus.Builder> result = ExecutionListCopier.copyToBuilder(this.executionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionList(Collection<ExecutionStatus.BuilderImpl> executionList) {
            this.executionList = ExecutionListCopier.copyFromBuilder(executionList);
        }

        @Override
        public final Builder executionList(Collection<ExecutionStatus> executionList) {
            this.executionList = ExecutionListCopier.copy(executionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionList(ExecutionStatus ... executionList) {
            this.executionList(Arrays.asList(executionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionList(Consumer<ExecutionStatus.Builder> ... executionList) {
            this.executionList(Stream.of(executionList).map(c -> (ExecutionStatus)((ExecutionStatus.Builder)ExecutionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAnomalyDetectionExecutionsResponse build() {
            return new DescribeAnomalyDetectionExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyDetectionExecutionsResponse> {
        public Builder executionList(Collection<ExecutionStatus> var1);

        public Builder executionList(ExecutionStatus ... var1);

        public Builder executionList(Consumer<ExecutionStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

