/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAlertRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<UpdateAlertRequest.Builder, UpdateAlertRequest> {
    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertArn").getter(getter(UpdateAlertRequest::alertArn)).setter(setter(Builder::alertArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()).build();

    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertDescription").getter(getter(UpdateAlertRequest::alertDescription))
            .setter(setter(Builder::alertDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()).build();

    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AlertSensitivityThreshold")
            .getter(getter(UpdateAlertRequest::alertSensitivityThreshold)).setter(setter(Builder::alertSensitivityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build())
            .build();

    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(UpdateAlertRequest::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<AlertFilters> ALERT_FILTERS_FIELD = SdkField.<AlertFilters> builder(MarshallingType.SDK_POJO)
            .memberName("AlertFilters").getter(getter(UpdateAlertRequest::alertFilters)).setter(setter(Builder::alertFilters))
            .constructor(AlertFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertFilters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_ARN_FIELD,
            ALERT_DESCRIPTION_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ACTION_FIELD, ALERT_FILTERS_FIELD));

    private final String alertArn;

    private final String alertDescription;

    private final Integer alertSensitivityThreshold;

    private final Action action;

    private final AlertFilters alertFilters;

    private UpdateAlertRequest(BuilderImpl builder) {
        super(builder);
        this.alertArn = builder.alertArn;
        this.alertDescription = builder.alertDescription;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.action = builder.action;
        this.alertFilters = builder.alertFilters;
    }

    /**
     * <p>
     * The ARN of the alert to update.
     * </p>
     * 
     * @return The ARN of the alert to update.
     */
    public final String alertArn() {
        return alertArn;
    }

    /**
     * <p>
     * A description of the alert.
     * </p>
     * 
     * @return A description of the alert.
     */
    public final String alertDescription() {
        return alertDescription;
    }

    /**
     * <p>
     * An integer from 0 to 100 specifying the alert sensitivity threshold.
     * </p>
     * 
     * @return An integer from 0 to 100 specifying the alert sensitivity threshold.
     */
    public final Integer alertSensitivityThreshold() {
        return alertSensitivityThreshold;
    }

    /**
     * <p>
     * Action that will be triggered when there is an alert.
     * </p>
     * 
     * @return Action that will be triggered when there is an alert.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * The configuration of the alert filters, containing MetricList and DimensionFilterList.
     * </p>
     * 
     * @return The configuration of the alert filters, containing MetricList and DimensionFilterList.
     */
    public final AlertFilters alertFilters() {
        return alertFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(alertFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAlertRequest)) {
            return false;
        }
        UpdateAlertRequest other = (UpdateAlertRequest) obj;
        return Objects.equals(alertArn(), other.alertArn()) && Objects.equals(alertDescription(), other.alertDescription())
                && Objects.equals(alertSensitivityThreshold(), other.alertSensitivityThreshold())
                && Objects.equals(action(), other.action()) && Objects.equals(alertFilters(), other.alertFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAlertRequest").add("AlertArn", alertArn()).add("AlertDescription", alertDescription())
                .add("AlertSensitivityThreshold", alertSensitivityThreshold()).add("Action", action())
                .add("AlertFilters", alertFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlertArn":
            return Optional.ofNullable(clazz.cast(alertArn()));
        case "AlertDescription":
            return Optional.ofNullable(clazz.cast(alertDescription()));
        case "AlertSensitivityThreshold":
            return Optional.ofNullable(clazz.cast(alertSensitivityThreshold()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "AlertFilters":
            return Optional.ofNullable(clazz.cast(alertFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAlertRequest, T> g) {
        return obj -> g.apply((UpdateAlertRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAlertRequest> {
        /**
         * <p>
         * The ARN of the alert to update.
         * </p>
         * 
         * @param alertArn
         *        The ARN of the alert to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertArn(String alertArn);

        /**
         * <p>
         * A description of the alert.
         * </p>
         * 
         * @param alertDescription
         *        A description of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertDescription(String alertDescription);

        /**
         * <p>
         * An integer from 0 to 100 specifying the alert sensitivity threshold.
         * </p>
         * 
         * @param alertSensitivityThreshold
         *        An integer from 0 to 100 specifying the alert sensitivity threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSensitivityThreshold(Integer alertSensitivityThreshold);

        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * 
         * @param action
         *        Action that will be triggered when there is an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The configuration of the alert filters, containing MetricList and DimensionFilterList.
         * </p>
         * 
         * @param alertFilters
         *        The configuration of the alert filters, containing MetricList and DimensionFilterList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertFilters(AlertFilters alertFilters);

        /**
         * <p>
         * The configuration of the alert filters, containing MetricList and DimensionFilterList.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlertFilters.Builder} avoiding the need
         * to create one manually via {@link AlertFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlertFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #alertFilters(AlertFilters)}.
         * 
         * @param alertFilters
         *        a consumer that will call methods on {@link AlertFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alertFilters(AlertFilters)
         */
        default Builder alertFilters(Consumer<AlertFilters.Builder> alertFilters) {
            return alertFilters(AlertFilters.builder().applyMutation(alertFilters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String alertArn;

        private String alertDescription;

        private Integer alertSensitivityThreshold;

        private Action action;

        private AlertFilters alertFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAlertRequest model) {
            super(model);
            alertArn(model.alertArn);
            alertDescription(model.alertDescription);
            alertSensitivityThreshold(model.alertSensitivityThreshold);
            action(model.action);
            alertFilters(model.alertFilters);
        }

        public final String getAlertArn() {
            return alertArn;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        @Override
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final String getAlertDescription() {
            return alertDescription;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        @Override
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final AlertFilters.Builder getAlertFilters() {
            return alertFilters != null ? alertFilters.toBuilder() : null;
        }

        public final void setAlertFilters(AlertFilters.BuilderImpl alertFilters) {
            this.alertFilters = alertFilters != null ? alertFilters.build() : null;
        }

        @Override
        public final Builder alertFilters(AlertFilters alertFilters) {
            this.alertFilters = alertFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAlertRequest build() {
            return new UpdateAlertRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
