/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for choosing a subset of dimension values. Each filter consists of the dimension that you want to
 * include and the condition statement. The condition statement is specified in the <code>FilterOperation</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValue").getter(getter(Filter::dimensionValue)).setter(setter(Builder::dimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()).build();

    private static final SdkField<String> FILTER_OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterOperation").getter(getter(Filter::filterOperationAsString))
            .setter(setter(Builder::filterOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUE_FIELD,
            FILTER_OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionValue;

    private final String filterOperation;

    private Filter(BuilderImpl builder) {
        this.dimensionValue = builder.dimensionValue;
        this.filterOperation = builder.filterOperation;
    }

    /**
     * <p>
     * The value that you want to include in the filter.
     * </p>
     * 
     * @return The value that you want to include in the filter.
     */
    public final String dimensionValue() {
        return dimensionValue;
    }

    /**
     * <p>
     * The condition to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterOperation}
     * will return {@link FilterOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterOperationAsString}.
     * </p>
     * 
     * @return The condition to apply.
     * @see FilterOperation
     */
    public final FilterOperation filterOperation() {
        return FilterOperation.fromValue(filterOperation);
    }

    /**
     * <p>
     * The condition to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterOperation}
     * will return {@link FilterOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterOperationAsString}.
     * </p>
     * 
     * @return The condition to apply.
     * @see FilterOperation
     */
    public final String filterOperationAsString() {
        return filterOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(filterOperationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(dimensionValue(), other.dimensionValue())
                && Objects.equals(filterOperationAsString(), other.filterOperationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("DimensionValue", dimensionValue())
                .add("FilterOperation", filterOperationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionValue":
            return Optional.ofNullable(clazz.cast(dimensionValue()));
        case "FilterOperation":
            return Optional.ofNullable(clazz.cast(filterOperationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The value that you want to include in the filter.
         * </p>
         * 
         * @param dimensionValue
         *        The value that you want to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValue(String dimensionValue);

        /**
         * <p>
         * The condition to apply.
         * </p>
         * 
         * @param filterOperation
         *        The condition to apply.
         * @see FilterOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperation
         */
        Builder filterOperation(String filterOperation);

        /**
         * <p>
         * The condition to apply.
         * </p>
         * 
         * @param filterOperation
         *        The condition to apply.
         * @see FilterOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperation
         */
        Builder filterOperation(FilterOperation filterOperation);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionValue;

        private String filterOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            dimensionValue(model.dimensionValue);
            filterOperation(model.filterOperation);
        }

        public final String getDimensionValue() {
            return dimensionValue;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final String getFilterOperation() {
            return filterOperation;
        }

        public final void setFilterOperation(String filterOperation) {
            this.filterOperation = filterOperation;
        }

        @Override
        public final Builder filterOperation(String filterOperation) {
            this.filterOperation = filterOperation;
            return this;
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            this.filterOperation(filterOperation == null ? null : filterOperation.toString());
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
