/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dimension filter, containing DimensionName and DimensionValueList.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionFilter implements SdkPojo, Serializable, ToCopyableBuilder<DimensionFilter.Builder, DimensionFilter> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(DimensionFilter::dimensionName)).setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final SdkField<List<String>> DIMENSION_VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DimensionValueList")
            .getter(getter(DimensionFilter::dimensionValueList))
            .setter(setter(Builder::dimensionValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD,
            DIMENSION_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionName;

    private final List<String> dimensionValueList;

    private DimensionFilter(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueList = builder.dimensionValueList;
    }

    /**
     * <p>
     * The name of the dimension to filter on.
     * </p>
     * 
     * @return The name of the dimension to filter on.
     */
    public final String dimensionName() {
        return dimensionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionValueList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionValueList() {
        return dimensionValueList != null && !(dimensionValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values for the dimension specified in DimensionName that you want to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionValueList} method.
     * </p>
     * 
     * @return The list of values for the dimension specified in DimensionName that you want to filter on.
     */
    public final List<String> dimensionValueList() {
        return dimensionValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionValueList() ? dimensionValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionFilter)) {
            return false;
        }
        DimensionFilter other = (DimensionFilter) obj;
        return Objects.equals(dimensionName(), other.dimensionName()) && hasDimensionValueList() == other.hasDimensionValueList()
                && Objects.equals(dimensionValueList(), other.dimensionValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionFilter").add("DimensionName", dimensionName())
                .add("DimensionValueList", hasDimensionValueList() ? dimensionValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        case "DimensionValueList":
            return Optional.ofNullable(clazz.cast(dimensionValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionFilter, T> g) {
        return obj -> g.apply((DimensionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionFilter> {
        /**
         * <p>
         * The name of the dimension to filter on.
         * </p>
         * 
         * @param dimensionName
         *        The name of the dimension to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * The list of values for the dimension specified in DimensionName that you want to filter on.
         * </p>
         * 
         * @param dimensionValueList
         *        The list of values for the dimension specified in DimensionName that you want to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueList(Collection<String> dimensionValueList);

        /**
         * <p>
         * The list of values for the dimension specified in DimensionName that you want to filter on.
         * </p>
         * 
         * @param dimensionValueList
         *        The list of values for the dimension specified in DimensionName that you want to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueList(String... dimensionValueList);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionName;

        private List<String> dimensionValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionFilter model) {
            dimensionName(model.dimensionName);
            dimensionValueList(model.dimensionValueList);
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final Collection<String> getDimensionValueList() {
            if (dimensionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionValueList;
        }

        public final void setDimensionValueList(Collection<String> dimensionValueList) {
            this.dimensionValueList = DimensionValueListCopier.copy(dimensionValueList);
        }

        @Override
        public final Builder dimensionValueList(Collection<String> dimensionValueList) {
            this.dimensionValueList = DimensionValueListCopier.copy(dimensionValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueList(String... dimensionValueList) {
            dimensionValueList(Arrays.asList(dimensionValueList));
            return this;
        }

        @Override
        public DimensionFilter build() {
            return new DimensionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
