/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon Athena datasource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AthenaSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AthenaSourceConfig.Builder, AthenaSourceConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AthenaSourceConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(AthenaSourceConfig::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DATA_CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataCatalog").getter(getter(AthenaSourceConfig::dataCatalog)).setter(setter(Builder::dataCatalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalog").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(AthenaSourceConfig::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> WORK_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroupName").getter(getter(AthenaSourceConfig::workGroupName)).setter(setter(Builder::workGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupName").build()).build();

    private static final SdkField<String> S3_RESULTS_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ResultsPath").getter(getter(AthenaSourceConfig::s3ResultsPath)).setter(setter(Builder::s3ResultsPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ResultsPath").build()).build();

    private static final SdkField<BackTestConfiguration> BACK_TEST_CONFIGURATION_FIELD = SdkField
            .<BackTestConfiguration> builder(MarshallingType.SDK_POJO).memberName("BackTestConfiguration")
            .getter(getter(AthenaSourceConfig::backTestConfiguration)).setter(setter(Builder::backTestConfiguration))
            .constructor(BackTestConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackTestConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DATABASE_NAME_FIELD, DATA_CATALOG_FIELD, TABLE_NAME_FIELD, WORK_GROUP_NAME_FIELD, S3_RESULTS_PATH_FIELD,
            BACK_TEST_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String databaseName;

    private final String dataCatalog;

    private final String tableName;

    private final String workGroupName;

    private final String s3ResultsPath;

    private final BackTestConfiguration backTestConfiguration;

    private AthenaSourceConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.databaseName = builder.databaseName;
        this.dataCatalog = builder.dataCatalog;
        this.tableName = builder.tableName;
        this.workGroupName = builder.workGroupName;
        this.s3ResultsPath = builder.s3ResultsPath;
        this.backTestConfiguration = builder.backTestConfiguration;
    }

    /**
     * <p>
     * An IAM role that gives Amazon Lookout for Metrics permission to access the data.
     * </p>
     * 
     * @return An IAM role that gives Amazon Lookout for Metrics permission to access the data.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The database's name.
     * </p>
     * 
     * @return The database's name.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The database's data catalog.
     * </p>
     * 
     * @return The database's data catalog.
     */
    public final String dataCatalog() {
        return dataCatalog;
    }

    /**
     * <p>
     * The database's table name.
     * </p>
     * 
     * @return The database's table name.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The database's work group name.
     * </p>
     * 
     * @return The database's work group name.
     */
    public final String workGroupName() {
        return workGroupName;
    }

    /**
     * <p>
     * The database's results path.
     * </p>
     * 
     * @return The database's results path.
     */
    public final String s3ResultsPath() {
        return s3ResultsPath;
    }

    /**
     * <p>
     * Settings for backtest mode.
     * </p>
     * 
     * @return Settings for backtest mode.
     */
    public final BackTestConfiguration backTestConfiguration() {
        return backTestConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(workGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(s3ResultsPath());
        hashCode = 31 * hashCode + Objects.hashCode(backTestConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaSourceConfig)) {
            return false;
        }
        AthenaSourceConfig other = (AthenaSourceConfig) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(dataCatalog(), other.dataCatalog()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(workGroupName(), other.workGroupName())
                && Objects.equals(s3ResultsPath(), other.s3ResultsPath())
                && Objects.equals(backTestConfiguration(), other.backTestConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AthenaSourceConfig").add("RoleArn", roleArn()).add("DatabaseName", databaseName())
                .add("DataCatalog", dataCatalog()).add("TableName", tableName()).add("WorkGroupName", workGroupName())
                .add("S3ResultsPath", s3ResultsPath()).add("BackTestConfiguration", backTestConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DataCatalog":
            return Optional.ofNullable(clazz.cast(dataCatalog()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "WorkGroupName":
            return Optional.ofNullable(clazz.cast(workGroupName()));
        case "S3ResultsPath":
            return Optional.ofNullable(clazz.cast(s3ResultsPath()));
        case "BackTestConfiguration":
            return Optional.ofNullable(clazz.cast(backTestConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AthenaSourceConfig, T> g) {
        return obj -> g.apply((AthenaSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AthenaSourceConfig> {
        /**
         * <p>
         * An IAM role that gives Amazon Lookout for Metrics permission to access the data.
         * </p>
         * 
         * @param roleArn
         *        An IAM role that gives Amazon Lookout for Metrics permission to access the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The database's name.
         * </p>
         * 
         * @param databaseName
         *        The database's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The database's data catalog.
         * </p>
         * 
         * @param dataCatalog
         *        The database's data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalog(String dataCatalog);

        /**
         * <p>
         * The database's table name.
         * </p>
         * 
         * @param tableName
         *        The database's table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The database's work group name.
         * </p>
         * 
         * @param workGroupName
         *        The database's work group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroupName(String workGroupName);

        /**
         * <p>
         * The database's results path.
         * </p>
         * 
         * @param s3ResultsPath
         *        The database's results path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResultsPath(String s3ResultsPath);

        /**
         * <p>
         * Settings for backtest mode.
         * </p>
         * 
         * @param backTestConfiguration
         *        Settings for backtest mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backTestConfiguration(BackTestConfiguration backTestConfiguration);

        /**
         * <p>
         * Settings for backtest mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackTestConfiguration.Builder} avoiding
         * the need to create one manually via {@link BackTestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackTestConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #backTestConfiguration(BackTestConfiguration)}.
         * 
         * @param backTestConfiguration
         *        a consumer that will call methods on {@link BackTestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backTestConfiguration(BackTestConfiguration)
         */
        default Builder backTestConfiguration(Consumer<BackTestConfiguration.Builder> backTestConfiguration) {
            return backTestConfiguration(BackTestConfiguration.builder().applyMutation(backTestConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String databaseName;

        private String dataCatalog;

        private String tableName;

        private String workGroupName;

        private String s3ResultsPath;

        private BackTestConfiguration backTestConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaSourceConfig model) {
            roleArn(model.roleArn);
            databaseName(model.databaseName);
            dataCatalog(model.dataCatalog);
            tableName(model.tableName);
            workGroupName(model.workGroupName);
            s3ResultsPath(model.s3ResultsPath);
            backTestConfiguration(model.backTestConfiguration);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataCatalog() {
            return dataCatalog;
        }

        public final void setDataCatalog(String dataCatalog) {
            this.dataCatalog = dataCatalog;
        }

        @Override
        public final Builder dataCatalog(String dataCatalog) {
            this.dataCatalog = dataCatalog;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getWorkGroupName() {
            return workGroupName;
        }

        public final void setWorkGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
        }

        @Override
        public final Builder workGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
            return this;
        }

        public final String getS3ResultsPath() {
            return s3ResultsPath;
        }

        public final void setS3ResultsPath(String s3ResultsPath) {
            this.s3ResultsPath = s3ResultsPath;
        }

        @Override
        public final Builder s3ResultsPath(String s3ResultsPath) {
            this.s3ResultsPath = s3ResultsPath;
            return this;
        }

        public final BackTestConfiguration.Builder getBackTestConfiguration() {
            return backTestConfiguration != null ? backTestConfiguration.toBuilder() : null;
        }

        public final void setBackTestConfiguration(BackTestConfiguration.BuilderImpl backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration != null ? backTestConfiguration.build() : null;
        }

        @Override
        public final Builder backTestConfiguration(BackTestConfiguration backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration;
            return this;
        }

        @Override
        public AthenaSourceConfig build() {
            return new AthenaSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
