/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.GetFeedbackResponse;

public class GetFeedbackIterable
implements SdkIterable<GetFeedbackResponse> {
    private final LookoutMetricsClient client;
    private final GetFeedbackRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFeedbackIterable(LookoutMetricsClient client, GetFeedbackRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetFeedbackResponseFetcher();
    }

    public Iterator<GetFeedbackResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetFeedbackResponseFetcher
    implements SyncPageFetcher<GetFeedbackResponse> {
        private GetFeedbackResponseFetcher() {
        }

        public boolean hasNextPage(GetFeedbackResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFeedbackResponse nextPage(GetFeedbackResponse previousPage) {
            if (previousPage == null) {
                return GetFeedbackIterable.this.client.getFeedback(GetFeedbackIterable.this.firstRequest);
            }
            return GetFeedbackIterable.this.client.getFeedback((GetFeedbackRequest)((Object)GetFeedbackIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

