/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;

public class ListAlertsIterable
implements SdkIterable<ListAlertsResponse> {
    private final LookoutMetricsClient client;
    private final ListAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlertsIterable(LookoutMetricsClient client, ListAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAlertsResponseFetcher();
    }

    public Iterator<ListAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAlertsResponseFetcher
    implements SyncPageFetcher<ListAlertsResponse> {
        private ListAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlertsResponse nextPage(ListAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListAlertsIterable.this.client.listAlerts(ListAlertsIterable.this.firstRequest);
            }
            return ListAlertsIterable.this.client.listAlerts((ListAlertsRequest)((Object)ListAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

