/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.Frequency;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.Metric;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSource;
import software.amazon.awssdk.services.lookoutmetrics.model.TimestampColumn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetricSetResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, DescribeMetricSetResponse> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetArn").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricSetArn)).setter(DescribeMetricSetResponse.setter(Builder::metricSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::anomalyDetectorArn)).setter(DescribeMetricSetResponse.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetName").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricSetName)).setter(DescribeMetricSetResponse.setter(Builder::metricSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()}).build();
    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetDescription").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricSetDescription)).setter(DescribeMetricSetResponse.setter(Builder::metricSetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::creationTime)).setter(DescribeMetricSetResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::lastModificationTime)).setter(DescribeMetricSetResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::offset)).setter(DescribeMetricSetResponse.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()}).build();
    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricList").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricList)).setter(DescribeMetricSetResponse.setter(Builder::metricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimestampColumn").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::timestampColumn)).setter(DescribeMetricSetResponse.setter(Builder::timestampColumn)).constructor(TimestampColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()}).build();
    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionList").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::dimensionList)).setter(DescribeMetricSetResponse.setter(Builder::dimensionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetFrequency").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricSetFrequencyAsString)).setter(DescribeMetricSetResponse.setter(Builder::metricSetFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::timezone)).setter(DescribeMetricSetResponse.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricSource").getter(DescribeMetricSetResponse.getter(DescribeMetricSetResponse::metricSource)).setter(DescribeMetricSetResponse.setter(Builder::metricSource)).constructor(MetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD, ANOMALY_DETECTOR_ARN_FIELD, METRIC_SET_NAME_FIELD, METRIC_SET_DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, OFFSET_FIELD, METRIC_LIST_FIELD, TIMESTAMP_COLUMN_FIELD, DIMENSION_LIST_FIELD, METRIC_SET_FREQUENCY_FIELD, TIMEZONE_FIELD, METRIC_SOURCE_FIELD));
    private final String metricSetArn;
    private final String anomalyDetectorArn;
    private final String metricSetName;
    private final String metricSetDescription;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final Integer offset;
    private final List<Metric> metricList;
    private final TimestampColumn timestampColumn;
    private final List<String> dimensionList;
    private final String metricSetFrequency;
    private final String timezone;
    private final MetricSource metricSource;

    private DescribeMetricSetResponse(BuilderImpl builder) {
        super(builder);
        this.metricSetArn = builder.metricSetArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetName = builder.metricSetName;
        this.metricSetDescription = builder.metricSetDescription;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.offset = builder.offset;
        this.metricList = builder.metricList;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.timezone = builder.timezone;
        this.metricSource = builder.metricSource;
    }

    public final String metricSetArn() {
        return this.metricSetArn;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String metricSetName() {
        return this.metricSetName;
    }

    public final String metricSetDescription() {
        return this.metricSetDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final boolean hasMetricList() {
        return this.metricList != null && !(this.metricList instanceof SdkAutoConstructList);
    }

    public final List<Metric> metricList() {
        return this.metricList;
    }

    public final TimestampColumn timestampColumn() {
        return this.timestampColumn;
    }

    public final boolean hasDimensionList() {
        return this.dimensionList != null && !(this.dimensionList instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionList() {
        return this.dimensionList;
    }

    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(this.metricSetFrequency);
    }

    public final String metricSetFrequencyAsString() {
        return this.metricSetFrequency;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final MetricSource metricSource() {
        return this.metricSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricList() ? this.metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionList() ? this.dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricSetResponse)) {
            return false;
        }
        DescribeMetricSetResponse other = (DescribeMetricSetResponse)((Object)obj);
        return Objects.equals(this.metricSetArn(), other.metricSetArn()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.metricSetName(), other.metricSetName()) && Objects.equals(this.metricSetDescription(), other.metricSetDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.offset(), other.offset()) && this.hasMetricList() == other.hasMetricList() && Objects.equals(this.metricList(), other.metricList()) && Objects.equals(this.timestampColumn(), other.timestampColumn()) && this.hasDimensionList() == other.hasDimensionList() && Objects.equals(this.dimensionList(), other.dimensionList()) && Objects.equals(this.metricSetFrequencyAsString(), other.metricSetFrequencyAsString()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.metricSource(), other.metricSource());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetricSetResponse").add("MetricSetArn", (Object)this.metricSetArn()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("MetricSetName", (Object)this.metricSetName()).add("MetricSetDescription", (Object)this.metricSetDescription()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Offset", (Object)this.offset()).add("MetricList", this.hasMetricList() ? this.metricList() : null).add("TimestampColumn", (Object)this.timestampColumn()).add("DimensionList", this.hasDimensionList() ? this.dimensionList() : null).add("MetricSetFrequency", (Object)this.metricSetFrequencyAsString()).add("Timezone", (Object)this.timezone()).add("MetricSource", (Object)this.metricSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSetArn": {
                return Optional.ofNullable(clazz.cast(this.metricSetArn()));
            }
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "MetricSetName": {
                return Optional.ofNullable(clazz.cast(this.metricSetName()));
            }
            case "MetricSetDescription": {
                return Optional.ofNullable(clazz.cast(this.metricSetDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "MetricList": {
                return Optional.ofNullable(clazz.cast(this.metricList()));
            }
            case "TimestampColumn": {
                return Optional.ofNullable(clazz.cast(this.timestampColumn()));
            }
            case "DimensionList": {
                return Optional.ofNullable(clazz.cast(this.dimensionList()));
            }
            case "MetricSetFrequency": {
                return Optional.ofNullable(clazz.cast(this.metricSetFrequencyAsString()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "MetricSource": {
                return Optional.ofNullable(clazz.cast(this.metricSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricSetResponse, T> g) {
        return obj -> g.apply((DescribeMetricSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private String metricSetArn;
        private String anomalyDetectorArn;
        private String metricSetName;
        private String metricSetDescription;
        private Instant creationTime;
        private Instant lastModificationTime;
        private Integer offset;
        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();
        private TimestampColumn timestampColumn;
        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();
        private String metricSetFrequency;
        private String timezone;
        private MetricSource metricSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricSetResponse model) {
            super(model);
            this.metricSetArn(model.metricSetArn);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.metricSetName(model.metricSetName);
            this.metricSetDescription(model.metricSetDescription);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.offset(model.offset);
            this.metricList(model.metricList);
            this.timestampColumn(model.timestampColumn);
            this.dimensionList(model.dimensionList);
            this.metricSetFrequency(model.metricSetFrequency);
            this.timezone(model.timezone);
            this.metricSource(model.metricSource);
        }

        public final String getMetricSetArn() {
            return this.metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetName() {
            return this.metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final String getMetricSetDescription() {
            return this.metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        @Override
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Metric ... metricList) {
            this.metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder> ... metricList) {
            this.metricList(Stream.of(metricList).map(c -> (Metric)((Metric.Builder)Metric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return this.timestampColumn != null ? this.timestampColumn.toBuilder() : null;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        @Override
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final Collection<String> getDimensionList() {
            if (this.dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionList;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        @Override
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(String ... dimensionList) {
            this.dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final String getMetricSetFrequency() {
            return this.metricSetFrequency;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        @Override
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final MetricSource.Builder getMetricSource() {
            return this.metricSource != null ? this.metricSource.toBuilder() : null;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        @Override
        public DescribeMetricSetResponse build() {
            return new DescribeMetricSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetricSetResponse> {
        public Builder metricSetArn(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder metricSetName(String var1);

        public Builder metricSetDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder offset(Integer var1);

        public Builder metricList(Collection<Metric> var1);

        public Builder metricList(Metric ... var1);

        public Builder metricList(Consumer<Metric.Builder> ... var1);

        public Builder timestampColumn(TimestampColumn var1);

        default public Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return this.timestampColumn((TimestampColumn)((TimestampColumn.Builder)TimestampColumn.builder().applyMutation(timestampColumn)).build());
        }

        public Builder dimensionList(Collection<String> var1);

        public Builder dimensionList(String ... var1);

        public Builder metricSetFrequency(String var1);

        public Builder metricSetFrequency(Frequency var1);

        public Builder timezone(String var1);

        public Builder metricSource(MetricSource var1);

        default public Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return this.metricSource((MetricSource)((MetricSource.Builder)MetricSource.builder().applyMutation(metricSource)).build());
        }
    }
}

