/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lookoutmetrics.model.Action;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAlertRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, CreateAlertRequest> {
    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertName").getter(CreateAlertRequest.getter(CreateAlertRequest::alertName)).setter(CreateAlertRequest.setter(Builder::alertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()}).build();
    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AlertSensitivityThreshold").getter(CreateAlertRequest.getter(CreateAlertRequest::alertSensitivityThreshold)).setter(CreateAlertRequest.setter(Builder::alertSensitivityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build()}).build();
    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertDescription").getter(CreateAlertRequest.getter(CreateAlertRequest::alertDescription)).setter(CreateAlertRequest.setter(Builder::alertDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(CreateAlertRequest.getter(CreateAlertRequest::anomalyDetectorArn)).setter(CreateAlertRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(CreateAlertRequest.getter(CreateAlertRequest::action)).setter(CreateAlertRequest.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAlertRequest.getter(CreateAlertRequest::tags)).setter(CreateAlertRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_NAME_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_DESCRIPTION_FIELD, ANOMALY_DETECTOR_ARN_FIELD, ACTION_FIELD, TAGS_FIELD));
    private final String alertName;
    private final Integer alertSensitivityThreshold;
    private final String alertDescription;
    private final String anomalyDetectorArn;
    private final Action action;
    private final Map<String, String> tags;

    private CreateAlertRequest(BuilderImpl builder) {
        super(builder);
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertDescription = builder.alertDescription;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.action = builder.action;
        this.tags = builder.tags;
    }

    public final String alertName() {
        return this.alertName;
    }

    public final Integer alertSensitivityThreshold() {
        return this.alertSensitivityThreshold;
    }

    public final String alertDescription() {
        return this.alertDescription;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final Action action() {
        return this.action;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlertRequest)) {
            return false;
        }
        CreateAlertRequest other = (CreateAlertRequest)((Object)obj);
        return Objects.equals(this.alertName(), other.alertName()) && Objects.equals(this.alertSensitivityThreshold(), other.alertSensitivityThreshold()) && Objects.equals(this.alertDescription(), other.alertDescription()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.action(), other.action()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAlertRequest").add("AlertName", (Object)this.alertName()).add("AlertSensitivityThreshold", (Object)this.alertSensitivityThreshold()).add("AlertDescription", (Object)this.alertDescription()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("Action", (Object)this.action()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertName": {
                return Optional.ofNullable(clazz.cast(this.alertName()));
            }
            case "AlertSensitivityThreshold": {
                return Optional.ofNullable(clazz.cast(this.alertSensitivityThreshold()));
            }
            case "AlertDescription": {
                return Optional.ofNullable(clazz.cast(this.alertDescription()));
            }
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAlertRequest, T> g) {
        return obj -> g.apply((CreateAlertRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String alertName;
        private Integer alertSensitivityThreshold;
        private String alertDescription;
        private String anomalyDetectorArn;
        private Action action;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAlertRequest model) {
            super(model);
            this.alertName(model.alertName);
            this.alertSensitivityThreshold(model.alertSensitivityThreshold);
            this.alertDescription(model.alertDescription);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.action(model.action);
            this.tags(model.tags);
        }

        public final String getAlertName() {
            return this.alertName;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        @Override
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return this.alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final String getAlertDescription() {
            return this.alertDescription;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        @Override
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAlertRequest build() {
            return new CreateAlertRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAlertRequest> {
        public Builder alertName(String var1);

        public Builder alertSensitivityThreshold(Integer var1);

        public Builder alertDescription(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

