/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;

@SdkInternalApi
public class SearchedLogStreamMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<Boolean> SEARCHEDCOMPLETELY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("searchedCompletely").build();
    private static final SearchedLogStreamMarshaller instance = new SearchedLogStreamMarshaller();

    public static SearchedLogStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(SearchedLogStream searchedLogStream, ProtocolMarshaller protocolMarshaller) {
        if (searchedLogStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)searchedLogStream.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)searchedLogStream.searchedCompletely(), SEARCHEDCOMPLETELY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

