/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;

@SdkInternalApi
public class PutLogEventsRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").build();
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<List> LOGEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logEvents").build();
    private static final MarshallingInfo<String> SEQUENCETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sequenceToken").build();
    private static final PutLogEventsRequestModelMarshaller instance = new PutLogEventsRequestModelMarshaller();

    public static PutLogEventsRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(PutLogEventsRequest putLogEventsRequest, ProtocolMarshaller protocolMarshaller) {
        if (putLogEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)putLogEventsRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)putLogEventsRequest.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall(putLogEventsRequest.logEvents(), LOGEVENTS_BINDING);
            protocolMarshaller.marshall((Object)putLogEventsRequest.sequenceToken(), SEQUENCETOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

