/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilterMatchRecord;

@SdkInternalApi
public class MetricFilterMatchRecordMarshaller {
    private static final MarshallingInfo<Long> EVENTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventNumber").build();
    private static final MarshallingInfo<String> EVENTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventMessage").build();
    private static final MarshallingInfo<Map> EXTRACTEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extractedValues").build();
    private static final MetricFilterMatchRecordMarshaller instance = new MetricFilterMatchRecordMarshaller();

    public static MetricFilterMatchRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricFilterMatchRecord metricFilterMatchRecord, ProtocolMarshaller protocolMarshaller) {
        if (metricFilterMatchRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricFilterMatchRecord.eventNumber(), EVENTNUMBER_BINDING);
            protocolMarshaller.marshall((Object)metricFilterMatchRecord.eventMessage(), EVENTMESSAGE_BINDING);
            protocolMarshaller.marshall(metricFilterMatchRecord.extractedValues(), EXTRACTEDVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

