/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;

@SdkInternalApi
public class LogStreamMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").build();
    private static final MarshallingInfo<Long> FIRSTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstEventTimestamp").build();
    private static final MarshallingInfo<Long> LASTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastEventTimestamp").build();
    private static final MarshallingInfo<Long> LASTINGESTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastIngestionTime").build();
    private static final MarshallingInfo<String> UPLOADSEQUENCETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uploadSequenceToken").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Long> STOREDBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storedBytes").build();
    private static final LogStreamMarshaller instance = new LogStreamMarshaller();

    public static LogStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(LogStream logStream, ProtocolMarshaller protocolMarshaller) {
        if (logStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)logStream.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)logStream.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logStream.firstEventTimestamp(), FIRSTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)logStream.lastEventTimestamp(), LASTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)logStream.lastIngestionTime(), LASTINGESTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logStream.uploadSequenceToken(), UPLOADSEQUENCETOKEN_BINDING);
            protocolMarshaller.marshall((Object)logStream.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)logStream.storedBytes(), STOREDBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

