/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;

@SdkInternalApi
public class LogGroupMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").build();
    private static final MarshallingInfo<Integer> RETENTIONINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retentionInDays").build();
    private static final MarshallingInfo<Integer> METRICFILTERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricFilterCount").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Long> STOREDBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storedBytes").build();
    private static final LogGroupMarshaller instance = new LogGroupMarshaller();

    public static LogGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(LogGroup logGroup, ProtocolMarshaller protocolMarshaller) {
        if (logGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)logGroup.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)logGroup.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logGroup.retentionInDays(), RETENTIONINDAYS_BINDING);
            protocolMarshaller.marshall((Object)logGroup.metricFilterCount(), METRICFILTERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)logGroup.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)logGroup.storedBytes(), STOREDBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

