/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;

@SdkInternalApi
public class InputLogEventMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final InputLogEventMarshaller instance = new InputLogEventMarshaller();

    public static InputLogEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputLogEvent inputLogEvent, ProtocolMarshaller protocolMarshaller) {
        if (inputLogEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputLogEvent.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)inputLogEvent.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

