/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;

@SdkInternalApi
public class FilteredLogEventMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<Long> INGESTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestionTime").build();
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final FilteredLogEventMarshaller instance = new FilteredLogEventMarshaller();

    public static FilteredLogEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(FilteredLogEvent filteredLogEvent, ProtocolMarshaller protocolMarshaller) {
        if (filteredLogEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)filteredLogEvent.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.ingestionTime(), INGESTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)filteredLogEvent.eventId(), EVENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

