/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTask;

@SdkInternalApi
public class ExportTaskMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").build();
    private static final MarshallingInfo<String> TASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskName").build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").build();
    private static final MarshallingInfo<Long> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").build();
    private static final MarshallingInfo<Long> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final MarshallingInfo<String> DESTINATIONPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationPrefix").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionInfo").build();
    private static final ExportTaskMarshaller instance = new ExportTaskMarshaller();

    public static ExportTaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExportTask exportTask, ProtocolMarshaller protocolMarshaller) {
        if (exportTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)exportTask.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)exportTask.taskName(), TASKNAME_BINDING);
            protocolMarshaller.marshall((Object)exportTask.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)exportTask.from(), FROM_BINDING);
            protocolMarshaller.marshall((Object)exportTask.to(), TO_BINDING);
            protocolMarshaller.marshall((Object)exportTask.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)exportTask.destinationPrefix(), DESTINATIONPREFIX_BINDING);
            protocolMarshaller.marshall((Object)exportTask.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)exportTask.executionInfo(), EXECUTIONINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

