/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UntagLogGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UntagLogGroupRequest> {
    private final String logGroupName;
    private final List<String> tags;

    private UntagLogGroupRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.tags = builder.tags;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public List<String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagLogGroupRequest)) {
            return false;
        }
        UntagLogGroupRequest other = (UntagLogGroupRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private List<String> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagLogGroupRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setTags(model.tags);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(String ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (String e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(String ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (String e : tags) {
                this.tags.add(e);
            }
        }

        public UntagLogGroupRequest build() {
            return new UntagLogGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UntagLogGroupRequest> {
        public Builder logGroupName(String var1);

        public Builder tags(Collection<String> var1);

        public Builder tags(String ... var1);
    }
}

