/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestEventMessagesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestMetricFilterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TestMetricFilterRequest> {
    private final String filterPattern;
    private final List<String> logEventMessages;

    private TestMetricFilterRequest(BuilderImpl builder) {
        this.filterPattern = builder.filterPattern;
        this.logEventMessages = builder.logEventMessages;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public List<String> logEventMessages() {
        return this.logEventMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filterPattern() == null ? 0 : this.filterPattern().hashCode());
        hashCode = 31 * hashCode + (this.logEventMessages() == null ? 0 : this.logEventMessages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterRequest)) {
            return false;
        }
        TestMetricFilterRequest other = (TestMetricFilterRequest)((Object)obj);
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.logEventMessages() == null ^ this.logEventMessages() == null) {
            return false;
        }
        return other.logEventMessages() == null || other.logEventMessages().equals(this.logEventMessages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filterPattern() != null) {
            sb.append("FilterPattern: ").append(this.filterPattern()).append(",");
        }
        if (this.logEventMessages() != null) {
            sb.append("LogEventMessages: ").append(this.logEventMessages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String filterPattern;
        private List<String> logEventMessages = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterRequest model) {
            this.setFilterPattern(model.filterPattern);
            this.setLogEventMessages(model.logEventMessages);
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<String> getLogEventMessages() {
            return this.logEventMessages;
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String ... logEventMessages) {
            if (this.logEventMessages == null) {
                this.logEventMessages = new SdkInternalList(logEventMessages.length);
            }
            for (String e : logEventMessages) {
                this.logEventMessages.add(e);
            }
            return this;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @SafeVarargs
        public final void setLogEventMessages(String ... logEventMessages) {
            if (this.logEventMessages == null) {
                this.logEventMessages = new SdkInternalList(logEventMessages.length);
            }
            for (String e : logEventMessages) {
                this.logEventMessages.add(e);
            }
        }

        public TestMetricFilterRequest build() {
            return new TestMetricFilterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TestMetricFilterRequest> {
        public Builder filterPattern(String var1);

        public Builder logEventMessages(Collection<String> var1);

        public Builder logEventMessages(String ... var1);
    }
}

