/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TagLogGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TagLogGroupRequest> {
    private final String logGroupName;
    private final Map<String, String> tags;

    private TagLogGroupRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.tags = builder.tags;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagLogGroupRequest)) {
            return false;
        }
        TagLogGroupRequest other = (TagLogGroupRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Map<String, String> tags = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(TagLogGroupRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setTags(model.tags);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public TagLogGroupRequest build() {
            return new TagLogGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TagLogGroupRequest> {
        public Builder logGroupName(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

