/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.SearchedLogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchedLogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, SearchedLogStream> {
    private final String logStreamName;
    private final Boolean searchedCompletely;

    private SearchedLogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.searchedCompletely = builder.searchedCompletely;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Boolean searchedCompletely() {
        return this.searchedCompletely;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        hashCode = 31 * hashCode + (this.searchedCompletely() == null ? 0 : this.searchedCompletely().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedLogStream)) {
            return false;
        }
        SearchedLogStream other = (SearchedLogStream)obj;
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.searchedCompletely() == null ^ this.searchedCompletely() == null) {
            return false;
        }
        return other.searchedCompletely() == null || other.searchedCompletely().equals(this.searchedCompletely());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        if (this.searchedCompletely() != null) {
            sb.append("SearchedCompletely: ").append(this.searchedCompletely()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchedLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Boolean searchedCompletely;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedLogStream model) {
            this.setLogStreamName(model.logStreamName);
            this.setSearchedCompletely(model.searchedCompletely);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Boolean getSearchedCompletely() {
            return this.searchedCompletely;
        }

        @Override
        public final Builder searchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
            return this;
        }

        public final void setSearchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
        }

        public SearchedLogStream build() {
            return new SearchedLogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchedLogStream> {
        public Builder logStreamName(String var1);

        public Builder searchedCompletely(Boolean var1);
    }
}

