/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutMetricFilterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutMetricFilterRequest> {
    private final String logGroupName;
    private final String filterName;
    private final String filterPattern;
    private final List<MetricTransformation> metricTransformations;

    private PutMetricFilterRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String filterName() {
        return this.filterName;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public List<MetricTransformation> metricTransformations() {
        return this.metricTransformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.filterName() == null ? 0 : this.filterName().hashCode());
        hashCode = 31 * hashCode + (this.filterPattern() == null ? 0 : this.filterPattern().hashCode());
        hashCode = 31 * hashCode + (this.metricTransformations() == null ? 0 : this.metricTransformations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.filterName() == null ^ this.filterName() == null) {
            return false;
        }
        if (other.filterName() != null && !other.filterName().equals(this.filterName())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.metricTransformations() == null ^ this.metricTransformations() == null) {
            return false;
        }
        return other.metricTransformations() == null || other.metricTransformations().equals(this.metricTransformations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.filterName() != null) {
            sb.append("FilterName: ").append(this.filterName()).append(",");
        }
        if (this.filterPattern() != null) {
            sb.append("FilterPattern: ").append(this.filterPattern()).append(",");
        }
        if (this.metricTransformations() != null) {
            sb.append("MetricTransformations: ").append(this.metricTransformations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String filterName;
        private String filterPattern;
        private List<MetricTransformation> metricTransformations = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricFilterRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setFilterName(model.filterName);
            this.setFilterPattern(model.filterPattern);
            this.setMetricTransformations(model.metricTransformations);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<MetricTransformation> getMetricTransformations() {
            return this.metricTransformations;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation ... metricTransformations) {
            if (this.metricTransformations == null) {
                this.metricTransformations = new SdkInternalList(metricTransformations.length);
            }
            for (MetricTransformation e : metricTransformations) {
                this.metricTransformations.add(e);
            }
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
        }

        @SafeVarargs
        public final void setMetricTransformations(MetricTransformation ... metricTransformations) {
            if (this.metricTransformations == null) {
                this.metricTransformations = new SdkInternalList(metricTransformations.length);
            }
            for (MetricTransformation e : metricTransformations) {
                this.metricTransformations.add(e);
            }
        }

        public PutMetricFilterRequest build() {
            return new PutMetricFilterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutMetricFilterRequest> {
        public Builder logGroupName(String var1);

        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder metricTransformations(Collection<MetricTransformation> var1);

        public Builder metricTransformations(MetricTransformation ... var1);
    }
}

