/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutLogEventsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutLogEventsRequest> {
    private final String logGroupName;
    private final String logStreamName;
    private final List<InputLogEvent> logEvents;
    private final String sequenceToken;

    private PutLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.logEvents = builder.logEvents;
        this.sequenceToken = builder.sequenceToken;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public List<InputLogEvent> logEvents() {
        return this.logEvents;
    }

    public String sequenceToken() {
        return this.sequenceToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        hashCode = 31 * hashCode + (this.logEvents() == null ? 0 : this.logEvents().hashCode());
        hashCode = 31 * hashCode + (this.sequenceToken() == null ? 0 : this.sequenceToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsRequest)) {
            return false;
        }
        PutLogEventsRequest other = (PutLogEventsRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.logEvents() == null ^ this.logEvents() == null) {
            return false;
        }
        if (other.logEvents() != null && !other.logEvents().equals(this.logEvents())) {
            return false;
        }
        if (other.sequenceToken() == null ^ this.sequenceToken() == null) {
            return false;
        }
        return other.sequenceToken() == null || other.sequenceToken().equals(this.sequenceToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        if (this.logEvents() != null) {
            sb.append("LogEvents: ").append(this.logEvents()).append(",");
        }
        if (this.sequenceToken() != null) {
            sb.append("SequenceToken: ").append(this.sequenceToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamName;
        private List<InputLogEvent> logEvents = new SdkInternalList();
        private String sequenceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamName(model.logStreamName);
            this.setLogEvents(model.logEvents);
            this.setSequenceToken(model.sequenceToken);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Collection<InputLogEvent> getLogEvents() {
            return this.logEvents;
        }

        @Override
        public final Builder logEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(InputLogEvent ... logEvents) {
            if (this.logEvents == null) {
                this.logEvents = new SdkInternalList(logEvents.length);
            }
            for (InputLogEvent e : logEvents) {
                this.logEvents.add(e);
            }
            return this;
        }

        public final void setLogEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
        }

        @SafeVarargs
        public final void setLogEvents(InputLogEvent ... logEvents) {
            if (this.logEvents == null) {
                this.logEvents = new SdkInternalList(logEvents.length);
            }
            for (InputLogEvent e : logEvents) {
                this.logEvents.add(e);
            }
        }

        public final String getSequenceToken() {
            return this.sequenceToken;
        }

        @Override
        public final Builder sequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
            return this;
        }

        public final void setSequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
        }

        public PutLogEventsRequest build() {
            return new PutLogEventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);

        public Builder logEvents(Collection<InputLogEvent> var1);

        public Builder logEvents(InputLogEvent ... var1);

        public Builder sequenceToken(String var1);
    }
}

