/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutDestinationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutDestinationRequest> {
    private final String destinationName;
    private final String targetArn;
    private final String roleArn;

    private PutDestinationRequest(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
    }

    public String destinationName() {
        return this.destinationName;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationName() == null ? 0 : this.destinationName().hashCode());
        hashCode = 31 * hashCode + (this.targetArn() == null ? 0 : this.targetArn().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationRequest)) {
            return false;
        }
        PutDestinationRequest other = (PutDestinationRequest)((Object)obj);
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationName() != null) {
            sb.append("DestinationName: ").append(this.destinationName()).append(",");
        }
        if (this.targetArn() != null) {
            sb.append("TargetArn: ").append(this.targetArn()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String destinationName;
        private String targetArn;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationRequest model) {
            this.setDestinationName(model.destinationName);
            this.setTargetArn(model.targetArn);
            this.setRoleArn(model.roleArn);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public PutDestinationRequest build() {
            return new PutDestinationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutDestinationRequest> {
        public Builder destinationName(String var1);

        public Builder targetArn(String var1);

        public Builder roleArn(String var1);
    }
}

