/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricTransformationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricTransformation
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricTransformation> {
    private final String metricName;
    private final String metricNamespace;
    private final String metricValue;
    private final Double defaultValue;

    private MetricTransformation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
        this.metricValue = builder.metricValue;
        this.defaultValue = builder.defaultValue;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public String metricValue() {
        return this.metricValue;
    }

    public Double defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.metricNamespace() == null ? 0 : this.metricNamespace().hashCode());
        hashCode = 31 * hashCode + (this.metricValue() == null ? 0 : this.metricValue().hashCode());
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation)obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.metricNamespace() == null ^ this.metricNamespace() == null) {
            return false;
        }
        if (other.metricNamespace() != null && !other.metricNamespace().equals(this.metricNamespace())) {
            return false;
        }
        if (other.metricValue() == null ^ this.metricValue() == null) {
            return false;
        }
        if (other.metricValue() != null && !other.metricValue().equals(this.metricValue())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        return other.defaultValue() == null || other.defaultValue().equals(this.defaultValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.metricNamespace() != null) {
            sb.append("MetricNamespace: ").append(this.metricNamespace()).append(",");
        }
        if (this.metricValue() != null) {
            sb.append("MetricValue: ").append(this.metricValue()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricTransformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String metricNamespace;
        private String metricValue;
        private Double defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricTransformation model) {
            this.setMetricName(model.metricName);
            this.setMetricNamespace(model.metricNamespace);
            this.setMetricValue(model.metricValue);
            this.setDefaultValue(model.defaultValue);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        public MetricTransformation build() {
            return new MetricTransformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricTransformation> {
        public Builder metricName(String var1);

        public Builder metricNamespace(String var1);

        public Builder metricValue(String var1);

        public Builder defaultValue(Double var1);
    }
}

