/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExtractedValuesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricFilterMatchRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricFilterMatchRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricFilterMatchRecord> {
    private final Long eventNumber;
    private final String eventMessage;
    private final Map<String, String> extractedValues;

    private MetricFilterMatchRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.extractedValues = builder.extractedValues;
    }

    public Long eventNumber() {
        return this.eventNumber;
    }

    public String eventMessage() {
        return this.eventMessage;
    }

    public Map<String, String> extractedValues() {
        return this.extractedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventNumber() == null ? 0 : this.eventNumber().hashCode());
        hashCode = 31 * hashCode + (this.eventMessage() == null ? 0 : this.eventMessage().hashCode());
        hashCode = 31 * hashCode + (this.extractedValues() == null ? 0 : this.extractedValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterMatchRecord)) {
            return false;
        }
        MetricFilterMatchRecord other = (MetricFilterMatchRecord)obj;
        if (other.eventNumber() == null ^ this.eventNumber() == null) {
            return false;
        }
        if (other.eventNumber() != null && !other.eventNumber().equals(this.eventNumber())) {
            return false;
        }
        if (other.eventMessage() == null ^ this.eventMessage() == null) {
            return false;
        }
        if (other.eventMessage() != null && !other.eventMessage().equals(this.eventMessage())) {
            return false;
        }
        if (other.extractedValues() == null ^ this.extractedValues() == null) {
            return false;
        }
        return other.extractedValues() == null || other.extractedValues().equals(this.extractedValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventNumber() != null) {
            sb.append("EventNumber: ").append(this.eventNumber()).append(",");
        }
        if (this.eventMessage() != null) {
            sb.append("EventMessage: ").append(this.eventMessage()).append(",");
        }
        if (this.extractedValues() != null) {
            sb.append("ExtractedValues: ").append(this.extractedValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricFilterMatchRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long eventNumber;
        private String eventMessage;
        private Map<String, String> extractedValues = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilterMatchRecord model) {
            this.setEventNumber(model.eventNumber);
            this.setEventMessage(model.eventMessage);
            this.setExtractedValues(model.extractedValues);
        }

        public final Long getEventNumber() {
            return this.eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        public final String getEventMessage() {
            return this.eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        public final Map<String, String> getExtractedValues() {
            return this.extractedValues;
        }

        @Override
        public final Builder extractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
            return this;
        }

        public final void setExtractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
        }

        public MetricFilterMatchRecord build() {
            return new MetricFilterMatchRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricFilterMatchRecord> {
        public Builder eventNumber(Long var1);

        public Builder eventMessage(String var1);

        public Builder extractedValues(Map<String, String> var1);
    }
}

