/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, LogStream> {
    private final String logStreamName;
    private final Long creationTime;
    private final Long firstEventTimestamp;
    private final Long lastEventTimestamp;
    private final Long lastIngestionTime;
    private final String uploadSequenceToken;
    private final String arn;
    private final Long storedBytes;

    private LogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.creationTime = builder.creationTime;
        this.firstEventTimestamp = builder.firstEventTimestamp;
        this.lastEventTimestamp = builder.lastEventTimestamp;
        this.lastIngestionTime = builder.lastIngestionTime;
        this.uploadSequenceToken = builder.uploadSequenceToken;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long firstEventTimestamp() {
        return this.firstEventTimestamp;
    }

    public Long lastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public Long lastIngestionTime() {
        return this.lastIngestionTime;
    }

    public String uploadSequenceToken() {
        return this.uploadSequenceToken;
    }

    public String arn() {
        return this.arn;
    }

    public Long storedBytes() {
        return this.storedBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.firstEventTimestamp() == null ? 0 : this.firstEventTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.lastEventTimestamp() == null ? 0 : this.lastEventTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.lastIngestionTime() == null ? 0 : this.lastIngestionTime().hashCode());
        hashCode = 31 * hashCode + (this.uploadSequenceToken() == null ? 0 : this.uploadSequenceToken().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.storedBytes() == null ? 0 : this.storedBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogStream)) {
            return false;
        }
        LogStream other = (LogStream)obj;
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.firstEventTimestamp() == null ^ this.firstEventTimestamp() == null) {
            return false;
        }
        if (other.firstEventTimestamp() != null && !other.firstEventTimestamp().equals(this.firstEventTimestamp())) {
            return false;
        }
        if (other.lastEventTimestamp() == null ^ this.lastEventTimestamp() == null) {
            return false;
        }
        if (other.lastEventTimestamp() != null && !other.lastEventTimestamp().equals(this.lastEventTimestamp())) {
            return false;
        }
        if (other.lastIngestionTime() == null ^ this.lastIngestionTime() == null) {
            return false;
        }
        if (other.lastIngestionTime() != null && !other.lastIngestionTime().equals(this.lastIngestionTime())) {
            return false;
        }
        if (other.uploadSequenceToken() == null ^ this.uploadSequenceToken() == null) {
            return false;
        }
        if (other.uploadSequenceToken() != null && !other.uploadSequenceToken().equals(this.uploadSequenceToken())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.storedBytes() == null ^ this.storedBytes() == null) {
            return false;
        }
        return other.storedBytes() == null || other.storedBytes().equals(this.storedBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.firstEventTimestamp() != null) {
            sb.append("FirstEventTimestamp: ").append(this.firstEventTimestamp()).append(",");
        }
        if (this.lastEventTimestamp() != null) {
            sb.append("LastEventTimestamp: ").append(this.lastEventTimestamp()).append(",");
        }
        if (this.lastIngestionTime() != null) {
            sb.append("LastIngestionTime: ").append(this.lastIngestionTime()).append(",");
        }
        if (this.uploadSequenceToken() != null) {
            sb.append("UploadSequenceToken: ").append(this.uploadSequenceToken()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.storedBytes() != null) {
            sb.append("StoredBytes: ").append(this.storedBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private Long creationTime;
        private Long firstEventTimestamp;
        private Long lastEventTimestamp;
        private Long lastIngestionTime;
        private String uploadSequenceToken;
        private String arn;
        private Long storedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(LogStream model) {
            this.setLogStreamName(model.logStreamName);
            this.setCreationTime(model.creationTime);
            this.setFirstEventTimestamp(model.firstEventTimestamp);
            this.setLastEventTimestamp(model.lastEventTimestamp);
            this.setLastIngestionTime(model.lastIngestionTime);
            this.setUploadSequenceToken(model.uploadSequenceToken);
            this.setArn(model.arn);
            this.setStoredBytes(model.storedBytes);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getFirstEventTimestamp() {
            return this.firstEventTimestamp;
        }

        @Override
        public final Builder firstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
            return this;
        }

        public final void setFirstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
        }

        public final Long getLastEventTimestamp() {
            return this.lastEventTimestamp;
        }

        @Override
        public final Builder lastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
            return this;
        }

        public final void setLastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
        }

        public final Long getLastIngestionTime() {
            return this.lastIngestionTime;
        }

        @Override
        public final Builder lastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
            return this;
        }

        public final void setLastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
        }

        public final String getUploadSequenceToken() {
            return this.uploadSequenceToken;
        }

        @Override
        public final Builder uploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
            return this;
        }

        public final void setUploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        public LogStream build() {
            return new LogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogStream> {
        public Builder logStreamName(String var1);

        public Builder creationTime(Long var1);

        public Builder firstEventTimestamp(Long var1);

        public Builder lastEventTimestamp(Long var1);

        public Builder lastIngestionTime(Long var1);

        public Builder uploadSequenceToken(String var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);
    }
}

