/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LogGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, LogGroup> {
    private final String logGroupName;
    private final Long creationTime;
    private final Integer retentionInDays;
    private final Integer metricFilterCount;
    private final String arn;
    private final Long storedBytes;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public Integer metricFilterCount() {
        return this.metricFilterCount;
    }

    public String arn() {
        return this.arn;
    }

    public Long storedBytes() {
        return this.storedBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.retentionInDays() == null ? 0 : this.retentionInDays().hashCode());
        hashCode = 31 * hashCode + (this.metricFilterCount() == null ? 0 : this.metricFilterCount().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.storedBytes() == null ? 0 : this.storedBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup)obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.retentionInDays() == null ^ this.retentionInDays() == null) {
            return false;
        }
        if (other.retentionInDays() != null && !other.retentionInDays().equals(this.retentionInDays())) {
            return false;
        }
        if (other.metricFilterCount() == null ^ this.metricFilterCount() == null) {
            return false;
        }
        if (other.metricFilterCount() != null && !other.metricFilterCount().equals(this.metricFilterCount())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.storedBytes() == null ^ this.storedBytes() == null) {
            return false;
        }
        return other.storedBytes() == null || other.storedBytes().equals(this.storedBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.retentionInDays() != null) {
            sb.append("RetentionInDays: ").append(this.retentionInDays()).append(",");
        }
        if (this.metricFilterCount() != null) {
            sb.append("MetricFilterCount: ").append(this.metricFilterCount()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.storedBytes() != null) {
            sb.append("StoredBytes: ").append(this.storedBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long creationTime;
        private Integer retentionInDays;
        private Integer metricFilterCount;
        private String arn;
        private Long storedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            this.setLogGroupName(model.logGroupName);
            this.setCreationTime(model.creationTime);
            this.setRetentionInDays(model.retentionInDays);
            this.setMetricFilterCount(model.metricFilterCount);
            this.setArn(model.arn);
            this.setStoredBytes(model.storedBytes);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        public final Integer getMetricFilterCount() {
            return this.metricFilterCount;
        }

        @Override
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        public LogGroup build() {
            return new LogGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogGroup> {
        public Builder logGroupName(String var1);

        public Builder creationTime(Long var1);

        public Builder retentionInDays(Integer var1);

        public Builder metricFilterCount(Integer var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);
    }
}

