/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.InputLogEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputLogEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, InputLogEvent> {
    private final Long timestamp;
    private final String message;

    private InputLogEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLogEvent)) {
            return false;
        }
        InputLogEvent other = (InputLogEvent)obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        return other.message() == null || other.message().equals(this.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLogEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLogEvent model) {
            this.setTimestamp(model.timestamp);
            this.setMessage(model.message);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public InputLogEvent build() {
            return new InputLogEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputLogEvent> {
        public Builder timestamp(Long var1);

        public Builder message(String var1);
    }
}

