/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLogEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetLogEventsResponse> {
    private final List<OutputLogEvent> events;
    private final String nextForwardToken;
    private final String nextBackwardToken;

    private GetLogEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextForwardToken = builder.nextForwardToken;
        this.nextBackwardToken = builder.nextBackwardToken;
    }

    public List<OutputLogEvent> events() {
        return this.events;
    }

    public String nextForwardToken() {
        return this.nextForwardToken;
    }

    public String nextBackwardToken() {
        return this.nextBackwardToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.nextForwardToken() == null ? 0 : this.nextForwardToken().hashCode());
        hashCode = 31 * hashCode + (this.nextBackwardToken() == null ? 0 : this.nextBackwardToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResponse)) {
            return false;
        }
        GetLogEventsResponse other = (GetLogEventsResponse)((Object)obj);
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextForwardToken() == null ^ this.nextForwardToken() == null) {
            return false;
        }
        if (other.nextForwardToken() != null && !other.nextForwardToken().equals(this.nextForwardToken())) {
            return false;
        }
        if (other.nextBackwardToken() == null ^ this.nextBackwardToken() == null) {
            return false;
        }
        return other.nextBackwardToken() == null || other.nextBackwardToken().equals(this.nextBackwardToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextForwardToken() != null) {
            sb.append("NextForwardToken: ").append(this.nextForwardToken()).append(",");
        }
        if (this.nextBackwardToken() != null) {
            sb.append("NextBackwardToken: ").append(this.nextBackwardToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OutputLogEvent> events = new SdkInternalList();
        private String nextForwardToken;
        private String nextBackwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsResponse model) {
            this.setEvents(model.events);
            this.setNextForwardToken(model.nextForwardToken);
            this.setNextBackwardToken(model.nextBackwardToken);
        }

        public final Collection<OutputLogEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(OutputLogEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (OutputLogEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(OutputLogEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (OutputLogEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextForwardToken() {
            return this.nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        public final String getNextBackwardToken() {
            return this.nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        public GetLogEventsResponse build() {
            return new GetLogEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetLogEventsResponse> {
        public Builder events(Collection<OutputLogEvent> var1);

        public Builder events(OutputLogEvent ... var1);

        public Builder nextForwardToken(String var1);

        public Builder nextBackwardToken(String var1);
    }
}

