/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLogEventsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetLogEventsRequest> {
    private final String logGroupName;
    private final String logStreamName;
    private final Long startTime;
    private final Long endTime;
    private final String nextToken;
    private final Integer limit;
    private final Boolean startFromHead;

    private GetLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.startFromHead = builder.startFromHead;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Long startTime() {
        return this.startTime;
    }

    public Long endTime() {
        return this.endTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean startFromHead() {
        return this.startFromHead;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.startFromHead() == null ? 0 : this.startFromHead().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsRequest)) {
            return false;
        }
        GetLogEventsRequest other = (GetLogEventsRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.startFromHead() == null ^ this.startFromHead() == null) {
            return false;
        }
        return other.startFromHead() == null || other.startFromHead().equals(this.startFromHead());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.startFromHead() != null) {
            sb.append("StartFromHead: ").append(this.startFromHead()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamName;
        private Long startTime;
        private Long endTime;
        private String nextToken;
        private Integer limit;
        private Boolean startFromHead;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamName(model.logStreamName);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
            this.setStartFromHead(model.startFromHead);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getStartFromHead() {
            return this.startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        public GetLogEventsRequest build() {
            return new GetLogEventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder startFromHead(Boolean var1);
    }
}

