/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEventsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStreamsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FilterLogEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, FilterLogEventsResponse> {
    private final List<FilteredLogEvent> events;
    private final List<SearchedLogStream> searchedLogStreams;
    private final String nextToken;

    private FilterLogEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.searchedLogStreams = builder.searchedLogStreams;
        this.nextToken = builder.nextToken;
    }

    public List<FilteredLogEvent> events() {
        return this.events;
    }

    public List<SearchedLogStream> searchedLogStreams() {
        return this.searchedLogStreams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.searchedLogStreams() == null ? 0 : this.searchedLogStreams().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResponse)) {
            return false;
        }
        FilterLogEventsResponse other = (FilterLogEventsResponse)((Object)obj);
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.searchedLogStreams() == null ^ this.searchedLogStreams() == null) {
            return false;
        }
        if (other.searchedLogStreams() != null && !other.searchedLogStreams().equals(this.searchedLogStreams())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.searchedLogStreams() != null) {
            sb.append("SearchedLogStreams: ").append(this.searchedLogStreams()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FilteredLogEvent> events = new SdkInternalList();
        private List<SearchedLogStream> searchedLogStreams = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsResponse model) {
            this.setEvents(model.events);
            this.setSearchedLogStreams(model.searchedLogStreams);
            this.setNextToken(model.nextToken);
        }

        public final Collection<FilteredLogEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(FilteredLogEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (FilteredLogEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(FilteredLogEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (FilteredLogEvent e : events) {
                this.events.add(e);
            }
        }

        public final Collection<SearchedLogStream> getSearchedLogStreams() {
            return this.searchedLogStreams;
        }

        @Override
        public final Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(SearchedLogStream ... searchedLogStreams) {
            if (this.searchedLogStreams == null) {
                this.searchedLogStreams = new SdkInternalList(searchedLogStreams.length);
            }
            for (SearchedLogStream e : searchedLogStreams) {
                this.searchedLogStreams.add(e);
            }
            return this;
        }

        public final void setSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
        }

        @SafeVarargs
        public final void setSearchedLogStreams(SearchedLogStream ... searchedLogStreams) {
            if (this.searchedLogStreams == null) {
                this.searchedLogStreams = new SdkInternalList(searchedLogStreams.length);
            }
            for (SearchedLogStream e : searchedLogStreams) {
                this.searchedLogStreams.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public FilterLogEventsResponse build() {
            return new FilterLogEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FilterLogEventsResponse> {
        public Builder events(Collection<FilteredLogEvent> var1);

        public Builder events(FilteredLogEvent ... var1);

        public Builder searchedLogStreams(Collection<SearchedLogStream> var1);

        public Builder searchedLogStreams(SearchedLogStream ... var1);

        public Builder nextToken(String var1);
    }
}

