/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogStreamNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FilterLogEventsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, FilterLogEventsRequest> {
    private final String logGroupName;
    private final List<String> logStreamNames;
    private final Long startTime;
    private final Long endTime;
    private final String filterPattern;
    private final String nextToken;
    private final Integer limit;
    private final Boolean interleaved;

    private FilterLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNames = builder.logStreamNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.interleaved = builder.interleaved;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public List<String> logStreamNames() {
        return this.logStreamNames;
    }

    public Long startTime() {
        return this.startTime;
    }

    public Long endTime() {
        return this.endTime;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean interleaved() {
        return this.interleaved;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamNames() == null ? 0 : this.logStreamNames().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.filterPattern() == null ? 0 : this.filterPattern().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.interleaved() == null ? 0 : this.interleaved().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest)((Object)obj);
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNames() == null ^ this.logStreamNames() == null) {
            return false;
        }
        if (other.logStreamNames() != null && !other.logStreamNames().equals(this.logStreamNames())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.interleaved() == null ^ this.interleaved() == null) {
            return false;
        }
        return other.interleaved() == null || other.interleaved().equals(this.interleaved());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamNames() != null) {
            sb.append("LogStreamNames: ").append(this.logStreamNames()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.filterPattern() != null) {
            sb.append("FilterPattern: ").append(this.filterPattern()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.interleaved() != null) {
            sb.append("Interleaved: ").append(this.interleaved()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private List<String> logStreamNames = new SdkInternalList();
        private Long startTime;
        private Long endTime;
        private String filterPattern;
        private String nextToken;
        private Integer limit;
        private Boolean interleaved;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsRequest model) {
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamNames(model.logStreamNames);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setFilterPattern(model.filterPattern);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
            this.setInterleaved(model.interleaved);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getLogStreamNames() {
            return this.logStreamNames;
        }

        @Override
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNames(String ... logStreamNames) {
            if (this.logStreamNames == null) {
                this.logStreamNames = new SdkInternalList(logStreamNames.length);
            }
            for (String e : logStreamNames) {
                this.logStreamNames.add(e);
            }
            return this;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @SafeVarargs
        public final void setLogStreamNames(String ... logStreamNames) {
            if (this.logStreamNames == null) {
                this.logStreamNames = new SdkInternalList(logStreamNames.length);
            }
            for (String e : logStreamNames) {
                this.logStreamNames.add(e);
            }
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getInterleaved() {
            return this.interleaved;
        }

        @Override
        public final Builder interleaved(Boolean interleaved) {
            this.interleaved = interleaved;
            return this;
        }

        public final void setInterleaved(Boolean interleaved) {
            this.interleaved = interleaved;
        }

        public FilterLogEventsRequest build() {
            return new FilterLogEventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FilterLogEventsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamNames(Collection<String> var1);

        public Builder logStreamNames(String ... var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder filterPattern(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder interleaved(Boolean var1);
    }
}

