/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ExportTaskExecutionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportTaskExecutionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ExportTaskExecutionInfo> {
    private final Long creationTime;
    private final Long completionTime;

    private ExportTaskExecutionInfo(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long completionTime() {
        return this.completionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.completionTime() == null ? 0 : this.completionTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskExecutionInfo)) {
            return false;
        }
        ExportTaskExecutionInfo other = (ExportTaskExecutionInfo)obj;
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.completionTime() == null ^ this.completionTime() == null) {
            return false;
        }
        return other.completionTime() == null || other.completionTime().equals(this.completionTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.completionTime() != null) {
            sb.append("CompletionTime: ").append(this.completionTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTaskExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long creationTime;
        private Long completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskExecutionInfo model) {
            this.setCreationTime(model.creationTime);
            this.setCompletionTime(model.completionTime);
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Long completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Long completionTime) {
            this.completionTime = completionTime;
        }

        public ExportTaskExecutionInfo build() {
            return new ExportTaskExecutionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportTaskExecutionInfo> {
        public Builder creationTime(Long var1);

        public Builder completionTime(Long var1);
    }
}

