/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskExecutionInfo;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskStatus;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ExportTaskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportTask
implements StructuredPojo,
ToCopyableBuilder<Builder, ExportTask> {
    private final String taskId;
    private final String taskName;
    private final String logGroupName;
    private final Long from;
    private final Long to;
    private final String destination;
    private final String destinationPrefix;
    private final ExportTaskStatus status;
    private final ExportTaskExecutionInfo executionInfo;

    private ExportTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
        this.status = builder.status;
        this.executionInfo = builder.executionInfo;
    }

    public String taskId() {
        return this.taskId;
    }

    public String taskName() {
        return this.taskName;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long from() {
        return this.from;
    }

    public Long to() {
        return this.to;
    }

    public String destination() {
        return this.destination;
    }

    public String destinationPrefix() {
        return this.destinationPrefix;
    }

    public ExportTaskStatus status() {
        return this.status;
    }

    public ExportTaskExecutionInfo executionInfo() {
        return this.executionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskId() == null ? 0 : this.taskId().hashCode());
        hashCode = 31 * hashCode + (this.taskName() == null ? 0 : this.taskName().hashCode());
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.from() == null ? 0 : this.from().hashCode());
        hashCode = 31 * hashCode + (this.to() == null ? 0 : this.to().hashCode());
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        hashCode = 31 * hashCode + (this.destinationPrefix() == null ? 0 : this.destinationPrefix().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.executionInfo() == null ? 0 : this.executionInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.taskName() == null ^ this.taskName() == null) {
            return false;
        }
        if (other.taskName() != null && !other.taskName().equals(this.taskName())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.from() == null ^ this.from() == null) {
            return false;
        }
        if (other.from() != null && !other.from().equals(this.from())) {
            return false;
        }
        if (other.to() == null ^ this.to() == null) {
            return false;
        }
        if (other.to() != null && !other.to().equals(this.to())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.destinationPrefix() == null ^ this.destinationPrefix() == null) {
            return false;
        }
        if (other.destinationPrefix() != null && !other.destinationPrefix().equals(this.destinationPrefix())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.executionInfo() == null ^ this.executionInfo() == null) {
            return false;
        }
        return other.executionInfo() == null || other.executionInfo().equals(this.executionInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskId() != null) {
            sb.append("TaskId: ").append(this.taskId()).append(",");
        }
        if (this.taskName() != null) {
            sb.append("TaskName: ").append(this.taskName()).append(",");
        }
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.from() != null) {
            sb.append("From: ").append(this.from()).append(",");
        }
        if (this.to() != null) {
            sb.append("To: ").append(this.to()).append(",");
        }
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.destinationPrefix() != null) {
            sb.append("DestinationPrefix: ").append(this.destinationPrefix()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.executionInfo() != null) {
            sb.append("ExecutionInfo: ").append(this.executionInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskName;
        private String logGroupName;
        private Long from;
        private Long to;
        private String destination;
        private String destinationPrefix;
        private ExportTaskStatus status;
        private ExportTaskExecutionInfo executionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.setTaskId(model.taskId);
            this.setTaskName(model.taskName);
            this.setLogGroupName(model.logGroupName);
            this.setFrom(model.from);
            this.setTo(model.to);
            this.setDestination(model.destination);
            this.setDestinationPrefix(model.destinationPrefix);
            this.setStatus(model.status);
            this.setExecutionInfo(model.executionInfo);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskName() {
            return this.taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return this.destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        public final ExportTaskStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ExportTaskStatus status) {
            this.status = status;
        }

        public final ExportTaskExecutionInfo getExecutionInfo() {
            return this.executionInfo;
        }

        @Override
        public final Builder executionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportTask> {
        public Builder taskId(String var1);

        public Builder taskName(String var1);

        public Builder logGroupName(String var1);

        public Builder from(Long var1);

        public Builder to(Long var1);

        public Builder destination(String var1);

        public Builder destinationPrefix(String var1);

        public Builder status(ExportTaskStatus var1);

        public Builder executionInfo(ExportTaskExecutionInfo var1);
    }
}

