/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DestinationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Destination
implements StructuredPojo,
ToCopyableBuilder<Builder, Destination> {
    private final String destinationName;
    private final String targetArn;
    private final String roleArn;
    private final String accessPolicy;
    private final String arn;
    private final Long creationTime;

    private Destination(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.accessPolicy = builder.accessPolicy;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
    }

    public String destinationName() {
        return this.destinationName;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String accessPolicy() {
        return this.accessPolicy;
    }

    public String arn() {
        return this.arn;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationName() == null ? 0 : this.destinationName().hashCode());
        hashCode = 31 * hashCode + (this.targetArn() == null ? 0 : this.targetArn().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.accessPolicy() == null ? 0 : this.accessPolicy().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.accessPolicy() == null ^ this.accessPolicy() == null) {
            return false;
        }
        if (other.accessPolicy() != null && !other.accessPolicy().equals(this.accessPolicy())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        return other.creationTime() == null || other.creationTime().equals(this.creationTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationName() != null) {
            sb.append("DestinationName: ").append(this.destinationName()).append(",");
        }
        if (this.targetArn() != null) {
            sb.append("TargetArn: ").append(this.targetArn()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.accessPolicy() != null) {
            sb.append("AccessPolicy: ").append(this.accessPolicy()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String destinationName;
        private String targetArn;
        private String roleArn;
        private String accessPolicy;
        private String arn;
        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.setDestinationName(model.destinationName);
            this.setTargetArn(model.targetArn);
            this.setRoleArn(model.roleArn);
            this.setAccessPolicy(model.accessPolicy);
            this.setArn(model.arn);
            this.setCreationTime(model.creationTime);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAccessPolicy() {
            return this.accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public Destination build() {
            return new Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Destination> {
        public Builder destinationName(String var1);

        public Builder targetArn(String var1);

        public Builder roleArn(String var1);

        public Builder accessPolicy(String var1);

        public Builder arn(String var1);

        public Builder creationTime(Long var1);
    }
}

