/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFiltersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSubscriptionFiltersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
    private final List<SubscriptionFilter> subscriptionFilters;
    private final String nextToken;

    private DescribeSubscriptionFiltersResponse(BuilderImpl builder) {
        this.subscriptionFilters = builder.subscriptionFilters;
        this.nextToken = builder.nextToken;
    }

    public List<SubscriptionFilter> subscriptionFilters() {
        return this.subscriptionFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionFilters() == null ? 0 : this.subscriptionFilters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersResponse)) {
            return false;
        }
        DescribeSubscriptionFiltersResponse other = (DescribeSubscriptionFiltersResponse)((Object)obj);
        if (other.subscriptionFilters() == null ^ this.subscriptionFilters() == null) {
            return false;
        }
        if (other.subscriptionFilters() != null && !other.subscriptionFilters().equals(this.subscriptionFilters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptionFilters() != null) {
            sb.append("SubscriptionFilters: ").append(this.subscriptionFilters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SubscriptionFilter> subscriptionFilters = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersResponse model) {
            this.setSubscriptionFilters(model.subscriptionFilters);
            this.setNextToken(model.nextToken);
        }

        public final Collection<SubscriptionFilter> getSubscriptionFilters() {
            return this.subscriptionFilters;
        }

        @Override
        public final Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(SubscriptionFilter ... subscriptionFilters) {
            if (this.subscriptionFilters == null) {
                this.subscriptionFilters = new SdkInternalList(subscriptionFilters.length);
            }
            for (SubscriptionFilter e : subscriptionFilters) {
                this.subscriptionFilters.add(e);
            }
            return this;
        }

        public final void setSubscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
        }

        @SafeVarargs
        public final void setSubscriptionFilters(SubscriptionFilter ... subscriptionFilters) {
            if (this.subscriptionFilters == null) {
                this.subscriptionFilters = new SdkInternalList(subscriptionFilters.length);
            }
            for (SubscriptionFilter e : subscriptionFilters) {
                this.subscriptionFilters.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeSubscriptionFiltersResponse build() {
            return new DescribeSubscriptionFiltersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
        public Builder subscriptionFilters(Collection<SubscriptionFilter> var1);

        public Builder subscriptionFilters(SubscriptionFilter ... var1);

        public Builder nextToken(String var1);
    }
}

