/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFiltersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMetricFiltersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMetricFiltersResponse> {
    private final List<MetricFilter> metricFilters;
    private final String nextToken;

    private DescribeMetricFiltersResponse(BuilderImpl builder) {
        this.metricFilters = builder.metricFilters;
        this.nextToken = builder.nextToken;
    }

    public List<MetricFilter> metricFilters() {
        return this.metricFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricFilters() == null ? 0 : this.metricFilters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersResponse)) {
            return false;
        }
        DescribeMetricFiltersResponse other = (DescribeMetricFiltersResponse)((Object)obj);
        if (other.metricFilters() == null ^ this.metricFilters() == null) {
            return false;
        }
        if (other.metricFilters() != null && !other.metricFilters().equals(this.metricFilters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricFilters() != null) {
            sb.append("MetricFilters: ").append(this.metricFilters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MetricFilter> metricFilters = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersResponse model) {
            this.setMetricFilters(model.metricFilters);
            this.setNextToken(model.nextToken);
        }

        public final Collection<MetricFilter> getMetricFilters() {
            return this.metricFilters;
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilter ... metricFilters) {
            if (this.metricFilters == null) {
                this.metricFilters = new SdkInternalList(metricFilters.length);
            }
            for (MetricFilter e : metricFilters) {
                this.metricFilters.add(e);
            }
            return this;
        }

        public final void setMetricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
        }

        @SafeVarargs
        public final void setMetricFilters(MetricFilter ... metricFilters) {
            if (this.metricFilters == null) {
                this.metricFilters = new SdkInternalList(metricFilters.length);
            }
            for (MetricFilter e : metricFilters) {
                this.metricFilters.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMetricFiltersResponse build() {
            return new DescribeMetricFiltersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMetricFiltersResponse> {
        public Builder metricFilters(Collection<MetricFilter> var1);

        public Builder metricFilters(MetricFilter ... var1);

        public Builder nextToken(String var1);
    }
}

