/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStreamsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLogStreamsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLogStreamsResponse> {
    private final List<LogStream> logStreams;
    private final String nextToken;

    private DescribeLogStreamsResponse(BuilderImpl builder) {
        this.logStreams = builder.logStreams;
        this.nextToken = builder.nextToken;
    }

    public List<LogStream> logStreams() {
        return this.logStreams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logStreams() == null ? 0 : this.logStreams().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsResponse)) {
            return false;
        }
        DescribeLogStreamsResponse other = (DescribeLogStreamsResponse)((Object)obj);
        if (other.logStreams() == null ^ this.logStreams() == null) {
            return false;
        }
        if (other.logStreams() != null && !other.logStreams().equals(this.logStreams())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logStreams() != null) {
            sb.append("LogStreams: ").append(this.logStreams()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LogStream> logStreams = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsResponse model) {
            this.setLogStreams(model.logStreams);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LogStream> getLogStreams() {
            return this.logStreams;
        }

        @Override
        public final Builder logStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(LogStream ... logStreams) {
            if (this.logStreams == null) {
                this.logStreams = new SdkInternalList(logStreams.length);
            }
            for (LogStream e : logStreams) {
                this.logStreams.add(e);
            }
            return this;
        }

        public final void setLogStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
        }

        @SafeVarargs
        public final void setLogStreams(LogStream ... logStreams) {
            if (this.logStreams == null) {
                this.logStreams = new SdkInternalList(logStreams.length);
            }
            for (LogStream e : logStreams) {
                this.logStreams.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeLogStreamsResponse build() {
            return new DescribeLogStreamsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLogStreamsResponse> {
        public Builder logStreams(Collection<LogStream> var1);

        public Builder logStreams(LogStream ... var1);

        public Builder nextToken(String var1);
    }
}

